/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// NOTE: this can me a union type here.. (integer | string;) so we need to get a bit creative
    /// </summary>
    [DataContract(Name = "LanguageServerProtocolCode")]
    public partial class LanguageServerProtocolCode : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolCode" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="codeInteger">codeInteger.</param>
        /// <param name="codeString">codeString.</param>
        /// <param name="rawJson">This is a Map&lt;String, String&gt;, basically just a json object for additional data if int/string will not work.</param>
        public LanguageServerProtocolCode(EmbeddedModelSchema schema = default(EmbeddedModelSchema), int codeInteger = default(int), string codeString = default(string), Dictionary<string, string> rawJson = default(Dictionary<string, string>))
        {
            this.Schema = schema;
            this.CodeInteger = codeInteger;
            this.CodeString = codeString;
            this.RawJson = rawJson;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets CodeInteger
        /// </summary>
        [DataMember(Name = "code_integer", EmitDefaultValue = false)]
        public int CodeInteger { get; set; }

        /// <summary>
        /// Gets or Sets CodeString
        /// </summary>
        [DataMember(Name = "code_string", EmitDefaultValue = false)]
        public string CodeString { get; set; }

        /// <summary>
        /// This is a Map&lt;String, String&gt;, basically just a json object for additional data if int/string will not work
        /// </summary>
        /// <value>This is a Map&lt;String, String&gt;, basically just a json object for additional data if int/string will not work</value>
        [DataMember(Name = "raw_json", EmitDefaultValue = false)]
        public Dictionary<string, string> RawJson { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class LanguageServerProtocolCode {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  CodeInteger: ").Append(CodeInteger).Append("\n");
            sb.Append("  CodeString: ").Append(CodeString).Append("\n");
            sb.Append("  RawJson: ").Append(RawJson).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
