/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// InteractedAssetInteractions
    /// </summary>
    [DataContract(Name = "InteractedAsset_interactions")]
    public partial class InteractedAssetInteractions : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="InteractedAssetInteractions" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected InteractedAssetInteractions() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="InteractedAssetInteractions" /> class.
        /// </summary>
        /// <param name="viewed">https://en.wikipedia.org/wiki/ISO_8601#Time_intervals (required).</param>
        /// <param name="touched">If the user touched or panned over the asset. (default to false).</param>
        /// <param name="scrolled">If the user scrolled over the asset. (default to false).</param>
        public InteractedAssetInteractions(string viewed = default(string), bool touched = false, bool scrolled = false)
        {
            // to ensure "viewed" is required (not null)
            if (viewed == null)
            {
                throw new ArgumentNullException("viewed is a required property for InteractedAssetInteractions and cannot be null");
            }
            this.Viewed = viewed;
            this.Touched = touched;
            this.Scrolled = scrolled;
        }

        /// <summary>
        /// https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
        /// </summary>
        /// <value>https://en.wikipedia.org/wiki/ISO_8601#Time_intervals</value>
        [DataMember(Name = "viewed", IsRequired = true, EmitDefaultValue = true)]
        public string Viewed { get; set; }

        /// <summary>
        /// If the user touched or panned over the asset.
        /// </summary>
        /// <value>If the user touched or panned over the asset.</value>
        [DataMember(Name = "touched", EmitDefaultValue = true)]
        public bool Touched { get; set; }

        /// <summary>
        /// If the user scrolled over the asset.
        /// </summary>
        /// <value>If the user scrolled over the asset.</value>
        [DataMember(Name = "scrolled", EmitDefaultValue = true)]
        public bool Scrolled { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class InteractedAssetInteractions {\n");
            sb.Append("  Viewed: ").Append(Viewed).Append("\n");
            sb.Append("  Touched: ").Append(Touched).Append("\n");
            sb.Append("  Scrolled: ").Append(Scrolled).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
                            if (this.Viewed != null) {
                                // Viewed (string) pattern
                Regex regexViewed = new Regex(@"P[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss]", RegexOptions.CultureInvariant);
                if (!regexViewed.Match(this.Viewed).Success)
                {
                    yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Viewed, must match a pattern of " + regexViewed, new [] { "Viewed" });
                }
                            }

            yield break;
        }
    }

}
