/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Note: parent is optional here in the case that (parent here is the integration that wants the module launched(VSCode))
    /// </summary>
    [DataContract(Name = "InactiveOSServerApplet")]
    public partial class InactiveOSServerApplet : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public OSAppletEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="InactiveOSServerApplet" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected InactiveOSServerApplet() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="InactiveOSServerApplet" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="parent">parent.</param>
        /// <param name="port">This is the port number in which we want to serve the copilot at..</param>
        /// <param name="type">type (required).</param>
        public InactiveOSServerApplet(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Application parent = default(Application), int? port = default(int?), OSAppletEnum type = default(OSAppletEnum))
        {
            this.Type = type;
            this.Schema = schema;
            this.Parent = parent;
            this.Port = port;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Parent
        /// </summary>
        [DataMember(Name = "parent", EmitDefaultValue = false)]
        public Application Parent { get; set; }

        /// <summary>
        /// This is the port number in which we want to serve the copilot at.
        /// </summary>
        /// <value>This is the port number in which we want to serve the copilot at.</value>
        [DataMember(Name = "port", EmitDefaultValue = true)]
        public int? Port { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class InactiveOSServerApplet {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Parent: ").Append(Parent).Append("\n");
            sb.Append("  Port: ").Append(Port).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
