/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a representation of an IDE Tab  value: is the value of the entire file(that being said we do not recomment passing this over as we can read this file on PieceOS side of things) classification: this is the classifcation of this file  selection: this is a represention of a copy/paste/selection of a bit of code  anchor: this is the file path  range: this is the duration that this user has been on this Tab  current: is a boolean that will let us know if this is the current active tab  contributors: is the people that are extracted via git  lsp: this is the languageserverprotocol this is used for may things such as error,stackstrces, mainly information extracted from the lang server
    /// </summary>
    [DataContract(Name = "IDETab")]
    public partial class IDETab : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="IDETab" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected IDETab() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="IDETab" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="value">value.</param>
        /// <param name="classification">classification.</param>
        /// <param name="selections">selections.</param>
        /// <param name="anchor">anchor (required).</param>
        /// <param name="range">range.</param>
        /// <param name="current">current.</param>
        /// <param name="contributors">contributors.</param>
        /// <param name="lsp">lsp.</param>
        public IDETab(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TransferableString value = default(TransferableString), Classification classification = default(Classification), IDESelections selections = default(IDESelections), SeededAnchor anchor = default(SeededAnchor), AnonymousTemporalRange range = default(AnonymousTemporalRange), bool current = default(bool), DocumentContributors contributors = default(DocumentContributors), LanguageServerProtocol lsp = default(LanguageServerProtocol))
        {
            // to ensure "anchor" is required (not null)
            if (anchor == null)
            {
                throw new ArgumentNullException("anchor is a required property for IDETab and cannot be null");
            }
            this.Anchor = anchor;
            this.Schema = schema;
            this.Value = value;
            this.Classification = classification;
            this.Selections = selections;
            this.Range = range;
            this.Current = current;
            this.Contributors = contributors;
            this.Lsp = lsp;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Value
        /// </summary>
        [DataMember(Name = "value", EmitDefaultValue = false)]
        public TransferableString Value { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", EmitDefaultValue = false)]
        public Classification Classification { get; set; }

        /// <summary>
        /// Gets or Sets Selections
        /// </summary>
        [DataMember(Name = "selections", EmitDefaultValue = false)]
        public IDESelections Selections { get; set; }

        /// <summary>
        /// Gets or Sets Anchor
        /// </summary>
        [DataMember(Name = "anchor", IsRequired = true, EmitDefaultValue = true)]
        public SeededAnchor Anchor { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", EmitDefaultValue = false)]
        public AnonymousTemporalRange Range { get; set; }

        /// <summary>
        /// Gets or Sets Current
        /// </summary>
        [DataMember(Name = "current", EmitDefaultValue = true)]
        public bool Current { get; set; }

        /// <summary>
        /// Gets or Sets Contributors
        /// </summary>
        [DataMember(Name = "contributors", EmitDefaultValue = false)]
        public DocumentContributors Contributors { get; set; }

        /// <summary>
        /// Gets or Sets Lsp
        /// </summary>
        [DataMember(Name = "lsp", EmitDefaultValue = false)]
        public LanguageServerProtocol Lsp { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class IDETab {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Value: ").Append(Value).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Selections: ").Append(Selections).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("  Current: ").Append(Current).Append("\n");
            sb.Append("  Contributors: ").Append(Contributors).Append("\n");
            sb.Append("  Lsp: ").Append(Lsp).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
