/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for monitoring and evaluating the OCR feature
    /// </summary>
    [DataContract(Name = "GraphicalOCRDescriptiveStatistics")]
    public partial class GraphicalOCRDescriptiveStatistics : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="GraphicalOCRDescriptiveStatistics" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected GraphicalOCRDescriptiveStatistics() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="GraphicalOCRDescriptiveStatistics" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="user">user (required).</param>
        /// <param name="model">model (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="os">os (required).</param>
        /// <param name="confidence">confidence (required).</param>
        /// <param name="duration">duration (required).</param>
        public GraphicalOCRDescriptiveStatistics(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string asset = default(string), string user = default(string), string model = default(string), string created = default(string), string os = default(string), GraphicalOCRDescriptiveStatisticsConfidence confidence = default(GraphicalOCRDescriptiveStatisticsConfidence), string duration = default(string))
        {
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Asset = asset;
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.User = user;
            // to ensure "model" is required (not null)
            if (model == null)
            {
                throw new ArgumentNullException("model is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Model = model;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Created = created;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Os = os;
            // to ensure "confidence" is required (not null)
            if (confidence == null)
            {
                throw new ArgumentNullException("confidence is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Confidence = confidence;
            // to ensure "duration" is required (not null)
            if (duration == null)
            {
                throw new ArgumentNullException("duration is a required property for GraphicalOCRDescriptiveStatistics and cannot be null");
            }
            this.Duration = duration;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", IsRequired = true, EmitDefaultValue = true)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public string Created { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// Gets or Sets Confidence
        /// </summary>
        [DataMember(Name = "confidence", IsRequired = true, EmitDefaultValue = true)]
        public GraphicalOCRDescriptiveStatisticsConfidence Confidence { get; set; }

        /// <summary>
        /// Gets or Sets Duration
        /// </summary>
        [DataMember(Name = "duration", IsRequired = true, EmitDefaultValue = true)]
        public string Duration { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class GraphicalOCRDescriptiveStatistics {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("  Confidence: ").Append(Confidence).Append("\n");
            sb.Append("  Duration: ").Append(Duration).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
