/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// GraphicalMachineLearningProcessingEvent
    /// </summary>
    [DataContract(Name = "GraphicalMachineLearningProcessingEvent")]
    public partial class GraphicalMachineLearningProcessingEvent : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="GraphicalMachineLearningProcessingEvent" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="ocr">ocr.</param>
        /// <param name="image">image.</param>
        /// <param name="svg">svg.</param>
        public GraphicalMachineLearningProcessingEvent(EmbeddedModelSchema schema = default(EmbeddedModelSchema), GraphicalOCRProcessing ocr = default(GraphicalOCRProcessing), GraphicalImageProcessing image = default(GraphicalImageProcessing), GraphicalSVGStatistics svg = default(GraphicalSVGStatistics))
        {
            this.Schema = schema;
            this.Ocr = ocr;
            this.Image = image;
            this.Svg = svg;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Ocr
        /// </summary>
        [DataMember(Name = "ocr", EmitDefaultValue = false)]
        public GraphicalOCRProcessing Ocr { get; set; }

        /// <summary>
        /// Gets or Sets Image
        /// </summary>
        [DataMember(Name = "image", EmitDefaultValue = false)]
        public GraphicalImageProcessing Image { get; set; }

        /// <summary>
        /// Gets or Sets Svg
        /// </summary>
        [DataMember(Name = "svg", EmitDefaultValue = false)]
        public GraphicalSVGStatistics Svg { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class GraphicalMachineLearningProcessingEvent {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Ocr: ").Append(Ocr).Append("\n");
            sb.Append("  Image: ").Append(Image).Append("\n");
            sb.Append("  Svg: ").Append(Svg).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
