/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for collecting descriptive statistics of images uploaded to Pieces
    /// </summary>
    [DataContract(Name = "GraphicalImageDescriptiveStatistics")]
    public partial class GraphicalImageDescriptiveStatistics : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="GraphicalImageDescriptiveStatistics" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected GraphicalImageDescriptiveStatistics() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="GraphicalImageDescriptiveStatistics" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="width">width (required).</param>
        /// <param name="height">height (required).</param>
        /// <param name="channels">channels (required).</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="user">user.</param>
        /// <param name="created">created (required).</param>
        /// <param name="os">os (required).</param>
        public GraphicalImageDescriptiveStatistics(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string width = default(string), string height = default(string), string channels = default(string), string asset = default(string), string user = default(string), string created = default(string), string os = default(string))
        {
            // to ensure "width" is required (not null)
            if (width == null)
            {
                throw new ArgumentNullException("width is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Width = width;
            // to ensure "height" is required (not null)
            if (height == null)
            {
                throw new ArgumentNullException("height is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Height = height;
            // to ensure "channels" is required (not null)
            if (channels == null)
            {
                throw new ArgumentNullException("channels is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Channels = channels;
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Asset = asset;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Created = created;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for GraphicalImageDescriptiveStatistics and cannot be null");
            }
            this.Os = os;
            this.Schema = schema;
            this.User = user;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Width
        /// </summary>
        [DataMember(Name = "width", IsRequired = true, EmitDefaultValue = true)]
        public string Width { get; set; }

        /// <summary>
        /// Gets or Sets Height
        /// </summary>
        [DataMember(Name = "height", IsRequired = true, EmitDefaultValue = true)]
        public string Height { get; set; }

        /// <summary>
        /// Gets or Sets Channels
        /// </summary>
        [DataMember(Name = "channels", IsRequired = true, EmitDefaultValue = true)]
        public string Channels { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", EmitDefaultValue = false)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public string Created { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class GraphicalImageDescriptiveStatistics {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Width: ").Append(Width).Append("\n");
            sb.Append("  Height: ").Append(Height).Append("\n");
            sb.Append("  Channels: ").Append(Channels).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
