/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a model that will represent the miminum properties required to update the classification of this format.
    /// </summary>
    [DataContract(Name = "FormatReclassification")]
    public partial class FormatReclassification : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Ext
        /// </summary>
        [DataMember(Name = "ext", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationSpecificEnum Ext { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="FormatReclassification" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FormatReclassification() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FormatReclassification" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="ext">ext (required).</param>
        /// <param name="format">format (required).</param>
        public FormatReclassification(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ClassificationSpecificEnum ext = default(ClassificationSpecificEnum), Format format = default(Format))
        {
            this.Ext = ext;
            // to ensure "format" is required (not null)
            if (format == null)
            {
                throw new ArgumentNullException("format is a required property for FormatReclassification and cannot be null");
            }
            this.Format = format;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = "format", IsRequired = true, EmitDefaultValue = true)]
        public Format Format { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FormatReclassification {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Ext: ").Append(Ext).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
