/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// FormatMetric  This is a model that will represent the about of specific formats. ie Generic: &#39;CODE&#39; specific: &#39;DART&#39; identifiers: [&#39;FormatUID1, &#39;FormatUID2&#39;]
    /// </summary>
    [DataContract(Name = "FormatMetric")]
    public partial class FormatMetric : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Generic
        /// </summary>
        [DataMember(Name = "generic", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationGenericEnum Generic { get; set; }

        /// <summary>
        /// Gets or Sets Specific
        /// </summary>
        [DataMember(Name = "specific", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationSpecificEnum Specific { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="FormatMetric" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FormatMetric() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FormatMetric" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="generic">generic (required).</param>
        /// <param name="specific">specific (required).</param>
        /// <param name="identifiers">this is a list of format ids (required).</param>
        public FormatMetric(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ClassificationGenericEnum generic = default(ClassificationGenericEnum), ClassificationSpecificEnum specific = default(ClassificationSpecificEnum), List<string> identifiers = default(List<string>))
        {
            this.Generic = generic;
            this.Specific = specific;
            // to ensure "identifiers" is required (not null)
            if (identifiers == null)
            {
                throw new ArgumentNullException("identifiers is a required property for FormatMetric and cannot be null");
            }
            this.Identifiers = identifiers;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// this is a list of format ids
        /// </summary>
        /// <value>this is a list of format ids</value>
        [DataMember(Name = "identifiers", IsRequired = true, EmitDefaultValue = true)]
        public List<string> Identifiers { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FormatMetric {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Generic: ").Append(Generic).Append("\n");
            sb.Append("  Specific: ").Append(Specific).Append("\n");
            sb.Append("  Identifiers: ").Append(Identifiers).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
