/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A representation of Data for a particular Form Factor of an Asset.  Below asset HAS to be Flattened because it is a leaf node and must prevent cycles agressively.
    /// </summary>
    [DataContract(Name = "Format")]
    public partial class Format : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Role
        /// </summary>
        [DataMember(Name = "role", IsRequired = true, EmitDefaultValue = true)]
        public Role Role { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="Format" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Format() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Format" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">id (required).</param>
        /// <param name="creator">creator (required).</param>
        /// <param name="classification">classification (required).</param>
        /// <param name="icon">icon.</param>
        /// <param name="role">role (required).</param>
        /// <param name="application">application (required).</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="bytes">bytes (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="updated">updated (required).</param>
        /// <param name="deleted">deleted.</param>
        /// <param name="synced">synced.</param>
        /// <param name="cloud">This is a path used to determine what path this format lives at within the cloud..</param>
        /// <param name="fragment">fragment.</param>
        /// <param name="file">file.</param>
        /// <param name="analysis">analysis.</param>
        /// <param name="relationship">relationship.</param>
        /// <param name="activities">activities.</param>
        public Format(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string creator = default(string), Classification classification = default(Classification), string icon = default(string), Role role = default(Role), Application application = default(Application), FlattenedAsset asset = default(FlattenedAsset), ByteDescriptor bytes = default(ByteDescriptor), GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), GroupedTimestamp deleted = default(GroupedTimestamp), GroupedTimestamp synced = default(GroupedTimestamp), string cloud = default(string), FragmentFormat fragment = default(FragmentFormat), FileFormat file = default(FileFormat), Analysis analysis = default(Analysis), Relationship relationship = default(Relationship), Activities activities = default(Activities))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for Format and cannot be null");
            }
            this.Id = id;
            // to ensure "creator" is required (not null)
            if (creator == null)
            {
                throw new ArgumentNullException("creator is a required property for Format and cannot be null");
            }
            this.Creator = creator;
            // to ensure "classification" is required (not null)
            if (classification == null)
            {
                throw new ArgumentNullException("classification is a required property for Format and cannot be null");
            }
            this.Classification = classification;
            this.Role = role;
            // to ensure "application" is required (not null)
            if (application == null)
            {
                throw new ArgumentNullException("application is a required property for Format and cannot be null");
            }
            this.Application = application;
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for Format and cannot be null");
            }
            this.Asset = asset;
            // to ensure "bytes" is required (not null)
            if (bytes == null)
            {
                throw new ArgumentNullException("bytes is a required property for Format and cannot be null");
            }
            this.Bytes = bytes;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for Format and cannot be null");
            }
            this.Created = created;
            // to ensure "updated" is required (not null)
            if (updated == null)
            {
                throw new ArgumentNullException("updated is a required property for Format and cannot be null");
            }
            this.Updated = updated;
            this.Schema = schema;
            this.Icon = icon;
            this.Deleted = deleted;
            this.Synced = synced;
            this.Cloud = cloud;
            this.Fragment = fragment;
            this.File = file;
            this.Analysis = analysis;
            this.Relationship = relationship;
            this.Activities = activities;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        /*
        <example>102ff265-fdfb-4142-8d94-4932d400199c</example>
        */
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Creator
        /// </summary>
        /*
        <example>497f6eca-6276-4993-bfeb-53cbbbba6f08</example>
        */
        [DataMember(Name = "creator", IsRequired = true, EmitDefaultValue = true)]
        public string Creator { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", IsRequired = true, EmitDefaultValue = true)]
        public Classification Classification { get; set; }

        /// <summary>
        /// Gets or Sets Icon
        /// </summary>
        [DataMember(Name = "icon", EmitDefaultValue = false)]
        public string Icon { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", IsRequired = true, EmitDefaultValue = true)]
        public Application Application { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public FlattenedAsset Asset { get; set; }

        /// <summary>
        /// Gets or Sets Bytes
        /// </summary>
        [DataMember(Name = "bytes", IsRequired = true, EmitDefaultValue = true)]
        public ByteDescriptor Bytes { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// Gets or Sets Deleted
        /// </summary>
        [DataMember(Name = "deleted", EmitDefaultValue = false)]
        public GroupedTimestamp Deleted { get; set; }

        /// <summary>
        /// Gets or Sets Synced
        /// </summary>
        [DataMember(Name = "synced", EmitDefaultValue = false)]
        public GroupedTimestamp Synced { get; set; }

        /// <summary>
        /// This is a path used to determine what path this format lives at within the cloud.
        /// </summary>
        /// <value>This is a path used to determine what path this format lives at within the cloud.</value>
        [DataMember(Name = "cloud", EmitDefaultValue = false)]
        public string Cloud { get; set; }

        /// <summary>
        /// Gets or Sets Fragment
        /// </summary>
        [DataMember(Name = "fragment", EmitDefaultValue = false)]
        public FragmentFormat Fragment { get; set; }

        /// <summary>
        /// Gets or Sets File
        /// </summary>
        [DataMember(Name = "file", EmitDefaultValue = false)]
        public FileFormat File { get; set; }

        /// <summary>
        /// Gets or Sets Analysis
        /// </summary>
        [DataMember(Name = "analysis", EmitDefaultValue = false)]
        public Analysis Analysis { get; set; }

        /// <summary>
        /// Gets or Sets Relationship
        /// </summary>
        [DataMember(Name = "relationship", EmitDefaultValue = false)]
        public Relationship Relationship { get; set; }

        /// <summary>
        /// Gets or Sets Activities
        /// </summary>
        [DataMember(Name = "activities", EmitDefaultValue = false)]
        public Activities Activities { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Format {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Creator: ").Append(Creator).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Icon: ").Append(Icon).Append("\n");
            sb.Append("  Role: ").Append(Role).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Bytes: ").Append(Bytes).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  Deleted: ").Append(Deleted).Append("\n");
            sb.Append("  Synced: ").Append(Synced).Append("\n");
            sb.Append("  Cloud: ").Append(Cloud).Append("\n");
            sb.Append("  Fragment: ").Append(Fragment).Append("\n");
            sb.Append("  File: ").Append(File).Append("\n");
            sb.Append("  Analysis: ").Append(Analysis).Append("\n");
            sb.Append("  Relationship: ").Append(Relationship).Append("\n");
            sb.Append("  Activities: ").Append(Activities).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
