/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a FlattenedUserProfile that includes information that is not sensative in relation to a user.
    /// </summary>
    [DataContract(Name = "FlattenedUserProfile")]
    public partial class FlattenedUserProfile : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedUserProfile" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FlattenedUserProfile() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedUserProfile" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">this is the uuid that identifies a user. (required).</param>
        /// <param name="email">email.</param>
        /// <param name="name">name.</param>
        /// <param name="username">username.</param>
        /// <param name="picture">picture.</param>
        /// <param name="vanityname">vanityname.</param>
        public FlattenedUserProfile(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string email = default(string), string name = default(string), string username = default(string), string picture = default(string), string vanityname = default(string))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for FlattenedUserProfile and cannot be null");
            }
            this.Id = id;
            this.Schema = schema;
            this.Email = email;
            this.Name = name;
            this.Username = username;
            this.Picture = picture;
            this.Vanityname = vanityname;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// this is the uuid that identifies a user.
        /// </summary>
        /// <value>this is the uuid that identifies a user.</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Email
        /// </summary>
        [DataMember(Name = "email", EmitDefaultValue = false)]
        public string Email { get; set; }

        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Username
        /// </summary>
        [DataMember(Name = "username", EmitDefaultValue = false)]
        public string Username { get; set; }

        /// <summary>
        /// Gets or Sets Picture
        /// </summary>
        [DataMember(Name = "picture", EmitDefaultValue = false)]
        public string Picture { get; set; }

        /// <summary>
        /// Gets or Sets Vanityname
        /// </summary>
        [DataMember(Name = "vanityname", EmitDefaultValue = false)]
        public string Vanityname { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FlattenedUserProfile {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Username: ").Append(Username).Append("\n");
            sb.Append("  Picture: ").Append(Picture).Append("\n");
            sb.Append("  Vanityname: ").Append(Vanityname).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
