/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a dag safe version of the Share.  if user is undefined &amp;&amp; access is public then we have an asset that is publicly available.
    /// </summary>
    [DataContract(Name = "FlattenedShare")]
    public partial class FlattenedShare : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Access
        /// </summary>
        [DataMember(Name = "access", IsRequired = true, EmitDefaultValue = true)]
        public AccessEnum Access { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedShare" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FlattenedShare() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedShare" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">This references the share it self. (required).</param>
        /// <param name="asset">this is the asset id on the flattened share..</param>
        /// <param name="user">this is the uuid of the user that the share is created for..</param>
        /// <param name="link">this is the prebuilt link. (required).</param>
        /// <param name="access">access (required).</param>
        /// <param name="accessors">accessors (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="varShort">This is a shortened version of our uuid. (required).</param>
        /// <param name="name">name.</param>
        /// <param name="assets">assets.</param>
        /// <param name="distributions">distributions.</param>
        /// <param name="score">score.</param>
        public FlattenedShare(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string asset = default(string), string user = default(string), string link = default(string), AccessEnum access = default(AccessEnum), Accessors accessors = default(Accessors), GroupedTimestamp created = default(GroupedTimestamp), string varShort = default(string), string name = default(string), FlattenedAssets assets = default(FlattenedAssets), FlattenedDistributions distributions = default(FlattenedDistributions), Score score = default(Score))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for FlattenedShare and cannot be null");
            }
            this.Id = id;
            // to ensure "link" is required (not null)
            if (link == null)
            {
                throw new ArgumentNullException("link is a required property for FlattenedShare and cannot be null");
            }
            this.Link = link;
            this.Access = access;
            // to ensure "accessors" is required (not null)
            if (accessors == null)
            {
                throw new ArgumentNullException("accessors is a required property for FlattenedShare and cannot be null");
            }
            this.Accessors = accessors;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for FlattenedShare and cannot be null");
            }
            this.Created = created;
            // to ensure "varShort" is required (not null)
            if (varShort == null)
            {
                throw new ArgumentNullException("varShort is a required property for FlattenedShare and cannot be null");
            }
            this.Short = varShort;
            this.Schema = schema;
            this.Asset = asset;
            this.User = user;
            this.Name = name;
            this.Assets = assets;
            this.Distributions = distributions;
            this.Score = score;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This references the share it self.
        /// </summary>
        /// <value>This references the share it self.</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// this is the asset id on the flattened share.
        /// </summary>
        /// <value>this is the asset id on the flattened share.</value>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public string Asset { get; set; }

        /// <summary>
        /// this is the uuid of the user that the share is created for.
        /// </summary>
        /// <value>this is the uuid of the user that the share is created for.</value>
        [DataMember(Name = "user", EmitDefaultValue = false)]
        public string User { get; set; }

        /// <summary>
        /// this is the prebuilt link.
        /// </summary>
        /// <value>this is the prebuilt link.</value>
        [DataMember(Name = "link", IsRequired = true, EmitDefaultValue = true)]
        public string Link { get; set; }

        /// <summary>
        /// Gets or Sets Accessors
        /// </summary>
        [DataMember(Name = "accessors", IsRequired = true, EmitDefaultValue = true)]
        public Accessors Accessors { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// This is a shortened version of our uuid.
        /// </summary>
        /// <value>This is a shortened version of our uuid.</value>
        [DataMember(Name = "short", IsRequired = true, EmitDefaultValue = true)]
        public string Short { get; set; }

        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public FlattenedAssets Assets { get; set; }

        /// <summary>
        /// Gets or Sets Distributions
        /// </summary>
        [DataMember(Name = "distributions", EmitDefaultValue = false)]
        public FlattenedDistributions Distributions { get; set; }

        /// <summary>
        /// Gets or Sets Score
        /// </summary>
        [DataMember(Name = "score", EmitDefaultValue = false)]
        public Score Score { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FlattenedShare {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Link: ").Append(Link).Append("\n");
            sb.Append("  Access: ").Append(Access).Append("\n");
            sb.Append("  Accessors: ").Append(Accessors).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Short: ").Append(Short).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Distributions: ").Append(Distributions).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
