/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// FlattenedImageAnalysis
    /// </summary>
    [DataContract(Name = "FlattenedImageAnalysis")]
    public partial class FlattenedImageAnalysis : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedImageAnalysis" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FlattenedImageAnalysis() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedImageAnalysis" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">id (required).</param>
        /// <param name="ocr">ocr.</param>
        /// <param name="analysis">this is a reference to our (parent)analysis (required).</param>
        public FlattenedImageAnalysis(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), FlattenedOCRAnalysis ocr = default(FlattenedOCRAnalysis), string analysis = default(string))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for FlattenedImageAnalysis and cannot be null");
            }
            this.Id = id;
            // to ensure "analysis" is required (not null)
            if (analysis == null)
            {
                throw new ArgumentNullException("analysis is a required property for FlattenedImageAnalysis and cannot be null");
            }
            this.Analysis = analysis;
            this.Schema = schema;
            this.Ocr = ocr;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Ocr
        /// </summary>
        [DataMember(Name = "ocr", EmitDefaultValue = false)]
        public FlattenedOCRAnalysis Ocr { get; set; }

        /// <summary>
        /// this is a reference to our (parent)analysis
        /// </summary>
        /// <value>this is a reference to our (parent)analysis</value>
        [DataMember(Name = "analysis", IsRequired = true, EmitDefaultValue = true)]
        public string Analysis { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FlattenedImageAnalysis {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Ocr: ").Append(Ocr).Append("\n");
            sb.Append("  Analysis: ").Append(Analysis).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
