/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a flattened version of the Convsersation for DAG-Safety.  This will hold together a conversation. Ie all the message within a conversation.  All the additional properties on here used on here like(anchors/assets) are used for context that will seed the conversation.  model is a calculated property, and will be the model of the last message sent if applicable.  summaries: on the top level here will simply be used to associate a conversation and a summary(this is not used for grounding), grounding.summaries will be used for this.(TODO)
    /// </summary>
    [DataContract(Name = "FlattenedConversation")]
    public partial class FlattenedConversation : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public ConversationTypeEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedConversation" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FlattenedConversation() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedConversation" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">id (required).</param>
        /// <param name="name">This is a name that is customized..</param>
        /// <param name="created">created (required).</param>
        /// <param name="updated">updated (required).</param>
        /// <param name="deleted">deleted.</param>
        /// <param name="favorited">favorited.</param>
        /// <param name="application">application.</param>
        /// <param name="annotations">annotations.</param>
        /// <param name="messages">messages (required).</param>
        /// <param name="model">model.</param>
        /// <param name="assets">assets.</param>
        /// <param name="websites">websites.</param>
        /// <param name="anchors">anchors.</param>
        /// <param name="type">type (required).</param>
        /// <param name="grounding">grounding.</param>
        /// <param name="score">score.</param>
        /// <param name="pipeline">pipeline.</param>
        /// <param name="demo">This will let us know if this conversation was generated as a &#39;demo&#39; conversation.</param>
        /// <param name="summaries">summaries.</param>
        public FlattenedConversation(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string name = default(string), GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), GroupedTimestamp deleted = default(GroupedTimestamp), bool favorited = default(bool), Application application = default(Application), FlattenedAnnotations annotations = default(FlattenedAnnotations), FlattenedConversationMessages messages = default(FlattenedConversationMessages), ReferencedModel model = default(ReferencedModel), FlattenedAssets assets = default(FlattenedAssets), FlattenedWebsites websites = default(FlattenedWebsites), FlattenedAnchors anchors = default(FlattenedAnchors), ConversationTypeEnum type = default(ConversationTypeEnum), ConversationGrounding grounding = default(ConversationGrounding), Score score = default(Score), QGPTPromptPipeline pipeline = default(QGPTPromptPipeline), bool demo = default(bool), FlattenedWorkstreamSummaries summaries = default(FlattenedWorkstreamSummaries))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for FlattenedConversation and cannot be null");
            }
            this.Id = id;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for FlattenedConversation and cannot be null");
            }
            this.Created = created;
            // to ensure "updated" is required (not null)
            if (updated == null)
            {
                throw new ArgumentNullException("updated is a required property for FlattenedConversation and cannot be null");
            }
            this.Updated = updated;
            // to ensure "messages" is required (not null)
            if (messages == null)
            {
                throw new ArgumentNullException("messages is a required property for FlattenedConversation and cannot be null");
            }
            this.Messages = messages;
            this.Type = type;
            this.Schema = schema;
            this.Name = name;
            this.Deleted = deleted;
            this.Favorited = favorited;
            this.Application = application;
            this.Annotations = annotations;
            this.Model = model;
            this.Assets = assets;
            this.Websites = websites;
            this.Anchors = anchors;
            this.Grounding = grounding;
            this.Score = score;
            this.Pipeline = pipeline;
            this.Demo = demo;
            this.Summaries = summaries;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// This is a name that is customized.
        /// </summary>
        /// <value>This is a name that is customized.</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// Gets or Sets Deleted
        /// </summary>
        [DataMember(Name = "deleted", EmitDefaultValue = false)]
        public GroupedTimestamp Deleted { get; set; }

        /// <summary>
        /// Gets or Sets Favorited
        /// </summary>
        [DataMember(Name = "favorited", EmitDefaultValue = true)]
        public bool Favorited { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", EmitDefaultValue = false)]
        public Application Application { get; set; }

        /// <summary>
        /// Gets or Sets Annotations
        /// </summary>
        [DataMember(Name = "annotations", EmitDefaultValue = false)]
        public FlattenedAnnotations Annotations { get; set; }

        /// <summary>
        /// Gets or Sets Messages
        /// </summary>
        [DataMember(Name = "messages", IsRequired = true, EmitDefaultValue = true)]
        public FlattenedConversationMessages Messages { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public ReferencedModel Model { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public FlattenedAssets Assets { get; set; }

        /// <summary>
        /// Gets or Sets Websites
        /// </summary>
        [DataMember(Name = "websites", EmitDefaultValue = false)]
        public FlattenedWebsites Websites { get; set; }

        /// <summary>
        /// Gets or Sets Anchors
        /// </summary>
        [DataMember(Name = "anchors", EmitDefaultValue = false)]
        public FlattenedAnchors Anchors { get; set; }

        /// <summary>
        /// Gets or Sets Grounding
        /// </summary>
        [DataMember(Name = "grounding", EmitDefaultValue = false)]
        public ConversationGrounding Grounding { get; set; }

        /// <summary>
        /// Gets or Sets Score
        /// </summary>
        [DataMember(Name = "score", EmitDefaultValue = false)]
        public Score Score { get; set; }

        /// <summary>
        /// Gets or Sets Pipeline
        /// </summary>
        [DataMember(Name = "pipeline", EmitDefaultValue = false)]
        public QGPTPromptPipeline Pipeline { get; set; }

        /// <summary>
        /// This will let us know if this conversation was generated as a &#39;demo&#39; conversation
        /// </summary>
        /// <value>This will let us know if this conversation was generated as a &#39;demo&#39; conversation</value>
        [DataMember(Name = "demo", EmitDefaultValue = true)]
        public bool Demo { get; set; }

        /// <summary>
        /// Gets or Sets Summaries
        /// </summary>
        [DataMember(Name = "summaries", EmitDefaultValue = false)]
        public FlattenedWorkstreamSummaries Summaries { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FlattenedConversation {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  Deleted: ").Append(Deleted).Append("\n");
            sb.Append("  Favorited: ").Append(Favorited).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Annotations: ").Append(Annotations).Append("\n");
            sb.Append("  Messages: ").Append(Messages).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Websites: ").Append(Websites).Append("\n");
            sb.Append("  Anchors: ").Append(Anchors).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Grounding: ").Append(Grounding).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("  Pipeline: ").Append(Pipeline).Append("\n");
            sb.Append("  Demo: ").Append(Demo).Append("\n");
            sb.Append("  Summaries: ").Append(Summaries).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
