/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// FlattenedAnalysis
    /// </summary>
    [DataContract(Name = "FlattenedAnalysis")]
    public partial class FlattenedAnalysis : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedAnalysis" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected FlattenedAnalysis() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FlattenedAnalysis" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="code">code.</param>
        /// <param name="id">id (required).</param>
        /// <param name="format">this is a reference to the format that it belongs too. (required).</param>
        /// <param name="image">image.</param>
        public FlattenedAnalysis(EmbeddedModelSchema schema = default(EmbeddedModelSchema), CodeAnalysis code = default(CodeAnalysis), string id = default(string), string format = default(string), FlattenedImageAnalysis image = default(FlattenedImageAnalysis))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for FlattenedAnalysis and cannot be null");
            }
            this.Id = id;
            // to ensure "format" is required (not null)
            if (format == null)
            {
                throw new ArgumentNullException("format is a required property for FlattenedAnalysis and cannot be null");
            }
            this.Format = format;
            this.Schema = schema;
            this.Code = code;
            this.Image = image;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Code
        /// </summary>
        [DataMember(Name = "code", EmitDefaultValue = false)]
        public CodeAnalysis Code { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// this is a reference to the format that it belongs too.
        /// </summary>
        /// <value>this is a reference to the format that it belongs too.</value>
        [DataMember(Name = "format", IsRequired = true, EmitDefaultValue = true)]
        public string Format { get; set; }

        /// <summary>
        /// Gets or Sets Image
        /// </summary>
        [DataMember(Name = "image", EmitDefaultValue = false)]
        public FlattenedImageAnalysis Image { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FlattenedAnalysis {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Image: ").Append(Image).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
