/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the input model for the FilePicker
    /// </summary>
    [DataContract(Name = "FilePickerInput")]
    public partial class FilePickerInput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FilePickerInput" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="allowedExtensions">allowedExtensions.</param>
        /// <param name="allowMultiple">default behavior is set to true.</param>
        public FilePickerInput(EmbeddedModelSchema schema = default(EmbeddedModelSchema), List<string> allowedExtensions = default(List<string>), bool allowMultiple = default(bool))
        {
            this.Schema = schema;
            this.AllowedExtensions = allowedExtensions;
            this.AllowMultiple = allowMultiple;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets AllowedExtensions
        /// </summary>
        [DataMember(Name = "allowedExtensions", EmitDefaultValue = false)]
        public List<string> AllowedExtensions { get; set; }

        /// <summary>
        /// default behavior is set to true
        /// </summary>
        /// <value>default behavior is set to true</value>
        [DataMember(Name = "allowMultiple", EmitDefaultValue = true)]
        public bool AllowMultiple { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FilePickerInput {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  AllowedExtensions: ").Append(AllowedExtensions).Append("\n");
            sb.Append("  AllowMultiple: ").Append(AllowMultiple).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
