/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// I know that profileData and user_id have differeing casing but they are done because they map to Auth0&#39;s projeecties.
    /// </summary>
    [DataContract(Name = "ExternalProvider")]
    public partial class ExternalProvider : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public ExternalProviderTypeEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProvider" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ExternalProvider() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProvider" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="type">type (required).</param>
        /// <param name="userId">This is the user_id within the provider. (required).</param>
        /// <param name="accessToken">This is optional here, but will be present for BB, Github, and google..</param>
        /// <param name="expiresIn">Some providers have an expiration on their access token. IE BB, Google, NOT Github..</param>
        /// <param name="created">created (required).</param>
        /// <param name="updated">updated (required).</param>
        /// <param name="profileData">profileData.</param>
        /// <param name="connection">This is an optional field that will be provided onentreprise connections. ie is type &#x3D;&#x3D; waad then connection might be PiecesApp. However is other cases,you my find your provider and connection is the exact same string. To decifer between the two, you can use the isSocial bool..</param>
        /// <param name="isSocial">isSocial.</param>
        public ExternalProvider(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ExternalProviderTypeEnum type = default(ExternalProviderTypeEnum), string userId = default(string), string accessToken = default(string), int expiresIn = default(int), GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), ExternalProviderProfileData profileData = default(ExternalProviderProfileData), string connection = default(string), bool isSocial = default(bool))
        {
            this.Type = type;
            // to ensure "userId" is required (not null)
            if (userId == null)
            {
                throw new ArgumentNullException("userId is a required property for ExternalProvider and cannot be null");
            }
            this.UserId = userId;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for ExternalProvider and cannot be null");
            }
            this.Created = created;
            // to ensure "updated" is required (not null)
            if (updated == null)
            {
                throw new ArgumentNullException("updated is a required property for ExternalProvider and cannot be null");
            }
            this.Updated = updated;
            this.Schema = schema;
            this.AccessToken = accessToken;
            this.ExpiresIn = expiresIn;
            this.ProfileData = profileData;
            this.Connection = connection;
            this.IsSocial = isSocial;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is the user_id within the provider.
        /// </summary>
        /// <value>This is the user_id within the provider.</value>
        [DataMember(Name = "user_id", IsRequired = true, EmitDefaultValue = true)]
        public string UserId { get; set; }

        /// <summary>
        /// This is optional here, but will be present for BB, Github, and google.
        /// </summary>
        /// <value>This is optional here, but will be present for BB, Github, and google.</value>
        [DataMember(Name = "access_token", EmitDefaultValue = false)]
        public string AccessToken { get; set; }

        /// <summary>
        /// Some providers have an expiration on their access token. IE BB, Google, NOT Github.
        /// </summary>
        /// <value>Some providers have an expiration on their access token. IE BB, Google, NOT Github.</value>
        [DataMember(Name = "expires_in", EmitDefaultValue = false)]
        public int ExpiresIn { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// Gets or Sets ProfileData
        /// </summary>
        [DataMember(Name = "profileData", EmitDefaultValue = false)]
        public ExternalProviderProfileData ProfileData { get; set; }

        /// <summary>
        /// This is an optional field that will be provided onentreprise connections. ie is type &#x3D;&#x3D; waad then connection might be PiecesApp. However is other cases,you my find your provider and connection is the exact same string. To decifer between the two, you can use the isSocial bool.
        /// </summary>
        /// <value>This is an optional field that will be provided onentreprise connections. ie is type &#x3D;&#x3D; waad then connection might be PiecesApp. However is other cases,you my find your provider and connection is the exact same string. To decifer between the two, you can use the isSocial bool.</value>
        [DataMember(Name = "connection", EmitDefaultValue = false)]
        public string Connection { get; set; }

        /// <summary>
        /// Gets or Sets IsSocial
        /// </summary>
        [DataMember(Name = "isSocial", EmitDefaultValue = true)]
        public bool IsSocial { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ExternalProvider {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  UserId: ").Append(UserId).Append("\n");
            sb.Append("  AccessToken: ").Append(AccessToken).Append("\n");
            sb.Append("  ExpiresIn: ").Append(ExpiresIn).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  ProfileData: ").Append(ProfileData).Append("\n");
            sb.Append("  Connection: ").Append(Connection).Append("\n");
            sb.Append("  IsSocial: ").Append(IsSocial).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
