/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// similarity: this is optional from 0 - 1, (where 1 is exact and 0 is everything)  TODO consider a plural of types for running many embedding search scopes
    /// </summary>
    [DataContract(Name = "EmbeddingsSearchOptions")]
    public partial class EmbeddingsSearchOptions : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public EmbeddingsSearchOptionsEmbeddingTypeEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="EmbeddingsSearchOptions" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected EmbeddingsSearchOptions() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="EmbeddingsSearchOptions" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="type">type (required).</param>
        /// <param name="similarity">similarity.</param>
        public EmbeddingsSearchOptions(EmbeddedModelSchema schema = default(EmbeddedModelSchema), EmbeddingsSearchOptionsEmbeddingTypeEnum type = default(EmbeddingsSearchOptionsEmbeddingTypeEnum), decimal similarity = default(decimal))
        {
            this.Type = type;
            this.Schema = schema;
            this.Similarity = similarity;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Similarity
        /// </summary>
        [DataMember(Name = "similarity", EmitDefaultValue = false)]
        public decimal Similarity { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class EmbeddingsSearchOptions {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Similarity: ").Append(Similarity).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
