/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a model that will keep track of all of our version related to our models. ie (1) the database migration and (2) the global semantic version of the api.
    /// </summary>
    [DataContract(Name = "EmbeddedModelSchema")]
    public partial class EmbeddedModelSchema : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Semantic
        /// </summary>
        [DataMember(Name = "semantic", IsRequired = true, EmitDefaultValue = true)]
        public EmbeddedModelSchemaSemanticVersionEnum Semantic { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="EmbeddedModelSchema" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected EmbeddedModelSchema() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="EmbeddedModelSchema" /> class.
        /// </summary>
        /// <param name="migration">this is the current database version that this model was used for. (required).</param>
        /// <param name="semantic">semantic (required).</param>
        public EmbeddedModelSchema(int migration = default(int), EmbeddedModelSchemaSemanticVersionEnum semantic = default(EmbeddedModelSchemaSemanticVersionEnum))
        {
            this.Migration = migration;
            this.Semantic = semantic;
        }

        /// <summary>
        /// this is the current database version that this model was used for.
        /// </summary>
        /// <value>this is the current database version that this model was used for.</value>
        [DataMember(Name = "migration", IsRequired = true, EmitDefaultValue = true)]
        public int Migration { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class EmbeddedModelSchema {\n");
            sb.Append("  Migration: ").Append(Migration).Append("\n");
            sb.Append("  Semantic: ").Append(Semantic).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
