/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This will return a discoveredSensitive, with a seed that can be used to create if automatic is set to false. and will provide the original text provided.
    /// </summary>
    [DataContract(Name = "DiscoveredSensitive")]
    public partial class DiscoveredSensitive : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveredSensitive" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected DiscoveredSensitive() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveredSensitive" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="seed">seed (required).</param>
        /// <param name="text">text (required).</param>
        public DiscoveredSensitive(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededSensitive seed = default(SeededSensitive), string text = default(string))
        {
            // to ensure "seed" is required (not null)
            if (seed == null)
            {
                throw new ArgumentNullException("seed is a required property for DiscoveredSensitive and cannot be null");
            }
            this.Seed = seed;
            // to ensure "text" is required (not null)
            if (text == null)
            {
                throw new ArgumentNullException("text is a required property for DiscoveredSensitive and cannot be null");
            }
            this.Text = text;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Seed
        /// </summary>
        [DataMember(Name = "seed", IsRequired = true, EmitDefaultValue = true)]
        public SeededSensitive Seed { get; set; }

        /// <summary>
        /// Gets or Sets Text
        /// </summary>
        [DataMember(Name = "text", IsRequired = true, EmitDefaultValue = true)]
        public string Text { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class DiscoveredSensitive {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Seed: ").Append(Seed).Append("\n");
            sb.Append("  Text: ").Append(Text).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
