/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// DiscoveredRelatedTag
    /// </summary>
    [DataContract(Name = "DiscoveredRelatedTag")]
    public partial class DiscoveredRelatedTag : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveredRelatedTag" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected DiscoveredRelatedTag() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveredRelatedTag" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="seed">seed (required).</param>
        public DiscoveredRelatedTag(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededTag seed = default(SeededTag))
        {
            // to ensure "seed" is required (not null)
            if (seed == null)
            {
                throw new ArgumentNullException("seed is a required property for DiscoveredRelatedTag and cannot be null");
            }
            this.Seed = seed;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Seed
        /// </summary>
        [DataMember(Name = "seed", IsRequired = true, EmitDefaultValue = true)]
        public SeededTag Seed { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class DiscoveredRelatedTag {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Seed: ").Append(Seed).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
