/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// DiscoveredAsset
    /// </summary>
    [DataContract(Name = "DiscoveredAsset")]
    public partial class DiscoveredAsset : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveredAsset" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="file">file.</param>
        /// <param name="fragment">fragment.</param>
        /// <param name="directory">directory.</param>
        /// <param name="metadata">metadata.</param>
        /// <param name="filters">filters.</param>
        public DiscoveredAsset(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededFile file = default(SeededFile), SeededFragment fragment = default(SeededFragment), string directory = default(string), SeededAssetMetadata metadata = default(SeededAssetMetadata), TLPDirectedDiscoveryFilters filters = default(TLPDirectedDiscoveryFilters))
        {
            this.Schema = schema;
            this.File = file;
            this.Fragment = fragment;
            this.Directory = directory;
            this.Metadata = metadata;
            this.Filters = filters;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets File
        /// </summary>
        [DataMember(Name = "file", EmitDefaultValue = false)]
        public SeededFile File { get; set; }

        /// <summary>
        /// Gets or Sets Fragment
        /// </summary>
        [DataMember(Name = "fragment", EmitDefaultValue = false)]
        public SeededFragment Fragment { get; set; }

        /// <summary>
        /// Gets or Sets Directory
        /// </summary>
        [DataMember(Name = "directory", EmitDefaultValue = false)]
        public string Directory { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public SeededAssetMetadata Metadata { get; set; }

        /// <summary>
        /// Gets or Sets Filters
        /// </summary>
        [DataMember(Name = "filters", EmitDefaultValue = false)]
        public TLPDirectedDiscoveryFilters Filters { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class DiscoveredAsset {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  File: ").Append(File).Append("\n");
            sb.Append("  Fragment: ").Append(Fragment).Append("\n");
            sb.Append("  Directory: ").Append(Directory).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("  Filters: ").Append(Filters).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
