/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the ML Analysis object Specific to code.  prediction and similarity are custom types. ** please dont not modify **
    /// </summary>
    [DataContract(Name = "CodeAnalysis")]
    public partial class CodeAnalysis : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationGenericEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="CodeAnalysis" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected CodeAnalysis() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="CodeAnalysis" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="tokenized">tokenized.</param>
        /// <param name="language">language.</param>
        /// <param name="type">type (required).</param>
        /// <param name="prediction">prediction.</param>
        /// <param name="similarity">similarity.</param>
        /// <param name="top5Colors">top5Colors.</param>
        /// <param name="top5Sorted">top5Sorted.</param>
        /// <param name="id">id (required).</param>
        /// <param name="analysis">this is just a reference to the analysis parent object. (required).</param>
        /// <param name="model">model (required).</param>
        public CodeAnalysis(EmbeddedModelSchema schema = default(EmbeddedModelSchema), List<string> tokenized = default(List<string>), string language = default(string), ClassificationGenericEnum type = default(ClassificationGenericEnum), Dictionary<string, decimal> prediction = default(Dictionary<string, decimal>), Dictionary<string, decimal> similarity = default(Dictionary<string, decimal>), List<int> top5Colors = default(List<int>), List<string> top5Sorted = default(List<string>), string id = default(string), string analysis = default(string), Model model = default(Model))
        {
            this.Type = type;
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for CodeAnalysis and cannot be null");
            }
            this.Id = id;
            // to ensure "analysis" is required (not null)
            if (analysis == null)
            {
                throw new ArgumentNullException("analysis is a required property for CodeAnalysis and cannot be null");
            }
            this.Analysis = analysis;
            // to ensure "model" is required (not null)
            if (model == null)
            {
                throw new ArgumentNullException("model is a required property for CodeAnalysis and cannot be null");
            }
            this.Model = model;
            this.Schema = schema;
            this.Tokenized = tokenized;
            this.Language = language;
            this.Prediction = prediction;
            this.Similarity = similarity;
            this.Top5Colors = top5Colors;
            this.Top5Sorted = top5Sorted;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Tokenized
        /// </summary>
        [DataMember(Name = "tokenized", EmitDefaultValue = false)]
        public List<string> Tokenized { get; set; }

        /// <summary>
        /// Gets or Sets Language
        /// </summary>
        [DataMember(Name = "language", EmitDefaultValue = false)]
        public string Language { get; set; }

        /// <summary>
        /// Gets or Sets Prediction
        /// </summary>
        [DataMember(Name = "prediction", EmitDefaultValue = false)]
        public Dictionary<string, decimal> Prediction { get; set; }

        /// <summary>
        /// Gets or Sets Similarity
        /// </summary>
        [DataMember(Name = "similarity", EmitDefaultValue = false)]
        public Dictionary<string, decimal> Similarity { get; set; }

        /// <summary>
        /// Gets or Sets Top5Colors
        /// </summary>
        [DataMember(Name = "top5Colors", EmitDefaultValue = false)]
        public List<int> Top5Colors { get; set; }

        /// <summary>
        /// Gets or Sets Top5Sorted
        /// </summary>
        [DataMember(Name = "top5Sorted", EmitDefaultValue = false)]
        public List<string> Top5Sorted { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// this is just a reference to the analysis parent object.
        /// </summary>
        /// <value>this is just a reference to the analysis parent object.</value>
        [DataMember(Name = "analysis", IsRequired = true, EmitDefaultValue = true)]
        public string Analysis { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", IsRequired = true, EmitDefaultValue = true)]
        public Model Model { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class CodeAnalysis {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Tokenized: ").Append(Tokenized).Append("\n");
            sb.Append("  Language: ").Append(Language).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Prediction: ").Append(Prediction).Append("\n");
            sb.Append("  Similarity: ").Append(Similarity).Append("\n");
            sb.Append("  Top5Colors: ").Append(Top5Colors).Append("\n");
            sb.Append("  Top5Sorted: ").Append(Top5Sorted).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Analysis: ").Append(Analysis).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
