/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the specific classification of an Asset&#39;s Format.(This is on a per format basis b/c an asset could have different formats that are different format representations of the Asset.)
    /// </summary>
    [DataContract(Name = "Classification")]
    public partial class Classification : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Generic
        /// </summary>
        [DataMember(Name = "generic", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationGenericEnum Generic { get; set; }

        /// <summary>
        /// Gets or Sets Specific
        /// </summary>
        [DataMember(Name = "specific", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationSpecificEnum Specific { get; set; }

        /// <summary>
        /// Gets or Sets Rendering
        /// </summary>
        [DataMember(Name = "rendering", EmitDefaultValue = false)]
        public ClassificationRenderingEnum? Rendering { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="Classification" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Classification() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Classification" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="generic">generic (required).</param>
        /// <param name="specific">specific (required).</param>
        /// <param name="rendering">rendering.</param>
        public Classification(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ClassificationGenericEnum generic = default(ClassificationGenericEnum), ClassificationSpecificEnum specific = default(ClassificationSpecificEnum), ClassificationRenderingEnum? rendering = default(ClassificationRenderingEnum?))
        {
            this.Generic = generic;
            this.Specific = specific;
            this.Schema = schema;
            this.Rendering = rendering;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Classification {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Generic: ").Append(Generic).Append("\n");
            sb.Append("  Specific: ").Append(Specific).Append("\n");
            sb.Append("  Rendering: ").Append(Rendering).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
