/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A model that Generates A PKCE Challenge Object with the needed requirements.
    /// </summary>
    [DataContract(Name = "ChallengedPKCE")]
    public partial class ChallengedPKCE : IValidatableObject
    {
        /// <summary>
        /// Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.
        /// </summary>
        /// <value>Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum MethodEnum
        {
            /// <summary>
            /// Enum S256 for value: S256
            /// </summary>
            [EnumMember(Value = "S256")]
            S256 = 1
        }


        /// <summary>
        /// Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.
        /// </summary>
        /// <value>Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</value>
        [DataMember(Name = "method", IsRequired = true, EmitDefaultValue = true)]
        public MethodEnum Method { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="ChallengedPKCE" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ChallengedPKCE() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ChallengedPKCE" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (required).</param>
        /// <param name="nonce">A local key that is held as the comparator to state, thus they should be the same. (required).</param>
        /// <param name="challenge">Generated challenge from the code_verifier. (required).</param>
        /// <param name="method">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged. (required).</param>
        /// <param name="verifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize. (required).</param>
        public ChallengedPKCE(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Guid state = default(Guid), Guid nonce = default(Guid), string challenge = default(string), MethodEnum method = default(MethodEnum), string verifier = default(string))
        {
            this.State = state;
            this.Nonce = nonce;
            // to ensure "challenge" is required (not null)
            if (challenge == null)
            {
                throw new ArgumentNullException("challenge is a required property for ChallengedPKCE and cannot be null");
            }
            this.Challenge = challenge;
            this.Method = method;
            // to ensure "verifier" is required (not null)
            if (verifier == null)
            {
                throw new ArgumentNullException("verifier is a required property for ChallengedPKCE and cannot be null");
            }
            this.Verifier = verifier;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks.
        /// </summary>
        /// <value>An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks.</value>
        [DataMember(Name = "state", IsRequired = true, EmitDefaultValue = true)]
        public Guid State { get; set; }

        /// <summary>
        /// A local key that is held as the comparator to state, thus they should be the same.
        /// </summary>
        /// <value>A local key that is held as the comparator to state, thus they should be the same.</value>
        [DataMember(Name = "nonce", IsRequired = true, EmitDefaultValue = true)]
        public Guid Nonce { get; set; }

        /// <summary>
        /// Generated challenge from the code_verifier.
        /// </summary>
        /// <value>Generated challenge from the code_verifier.</value>
        [DataMember(Name = "challenge", IsRequired = true, EmitDefaultValue = true)]
        public string Challenge { get; set; }

        /// <summary>
        /// Cryptographically random key that was used to generate the code_challenge passed to /authorize.
        /// </summary>
        /// <value>Cryptographically random key that was used to generate the code_challenge passed to /authorize.</value>
        [DataMember(Name = "verifier", IsRequired = true, EmitDefaultValue = true)]
        public string Verifier { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ChallengedPKCE {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  State: ").Append(State).Append("\n");
            sb.Append("  Nonce: ").Append(Nonce).Append("\n");
            sb.Append("  Challenge: ").Append(Challenge).Append("\n");
            sb.Append("  Method: ").Append(Method).Append("\n");
            sb.Append("  Verifier: ").Append(Verifier).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
