/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a nice microclass to help with managing the size of a File or Fragment in a readable way for UI&#39;s
    /// </summary>
    [DataContract(Name = "ByteDescriptor")]
    public partial class ByteDescriptor : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ByteDescriptor" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ByteDescriptor() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ByteDescriptor" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="value">value (required).</param>
        /// <param name="readable">readable (required).</param>
        public ByteDescriptor(EmbeddedModelSchema schema = default(EmbeddedModelSchema), long value = default(long), string readable = default(string))
        {
            this.Value = value;
            // to ensure "readable" is required (not null)
            if (readable == null)
            {
                throw new ArgumentNullException("readable is a required property for ByteDescriptor and cannot be null");
            }
            this.Readable = readable;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Value
        /// </summary>
        /*
        <example>33600</example>
        */
        [DataMember(Name = "value", IsRequired = true, EmitDefaultValue = true)]
        public long Value { get; set; }

        /// <summary>
        /// Gets or Sets Readable
        /// </summary>
        /*
        <example>33.6 KB</example>
        */
        [DataMember(Name = "readable", IsRequired = true, EmitDefaultValue = true)]
        public string Readable { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ByteDescriptor {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Value: ").Append(Value).Append("\n");
            sb.Append("  Readable: ").Append(Readable).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
