/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// a tab can have many values because you might want to pass in a value that represents the code_blocks(snippets) or a md represenet note: please only pass 1 representation, I will clean on POS side tho (txt || md || html)  anchor: can be defined in the browser if view a local file  website: this is the given url of the tab  range: this is the amount of time this user is current on this given tab  current: means that this is the current tab that is open  contributors: these are all the extracted people from this given tab
    /// </summary>
    [DataContract(Name = "BrowserTab")]
    public partial class BrowserTab : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="BrowserTab" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="values">values.</param>
        /// <param name="anchor">anchor.</param>
        /// <param name="website">website.</param>
        /// <param name="range">range.</param>
        /// <param name="current">current.</param>
        /// <param name="contributors">contributors.</param>
        public BrowserTab(EmbeddedModelSchema schema = default(EmbeddedModelSchema), BrowserTabValues values = default(BrowserTabValues), SeededAnchor anchor = default(SeededAnchor), SeededWebsite website = default(SeededWebsite), AnonymousTemporalRange range = default(AnonymousTemporalRange), bool current = default(bool), DocumentContributors contributors = default(DocumentContributors))
        {
            this.Schema = schema;
            this.Values = values;
            this.Anchor = anchor;
            this.Website = website;
            this.Range = range;
            this.Current = current;
            this.Contributors = contributors;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Values
        /// </summary>
        [DataMember(Name = "values", EmitDefaultValue = false)]
        public BrowserTabValues Values { get; set; }

        /// <summary>
        /// Gets or Sets Anchor
        /// </summary>
        [DataMember(Name = "anchor", EmitDefaultValue = false)]
        public SeededAnchor Anchor { get; set; }

        /// <summary>
        /// Gets or Sets Website
        /// </summary>
        [DataMember(Name = "website", EmitDefaultValue = false)]
        public SeededWebsite Website { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", EmitDefaultValue = false)]
        public AnonymousTemporalRange Range { get; set; }

        /// <summary>
        /// Gets or Sets Current
        /// </summary>
        [DataMember(Name = "current", EmitDefaultValue = true)]
        public bool Current { get; set; }

        /// <summary>
        /// Gets or Sets Contributors
        /// </summary>
        [DataMember(Name = "contributors", EmitDefaultValue = false)]
        public DocumentContributors Contributors { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class BrowserTab {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Values: ").Append(Values).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  Website: ").Append(Website).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("  Current: ").Append(Current).Append("\n");
            sb.Append("  Contributors: ").Append(Contributors).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
