/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a given bit of text/code that is selected in the browser, this can be a copy/paste/selection
    /// </summary>
    [DataContract(Name = "BrowserSelection")]
    public partial class BrowserSelection : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="BrowserSelection" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected BrowserSelection() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="BrowserSelection" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="classification">classification (required).</param>
        /// <param name="value">value (required).</param>
        public BrowserSelection(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Classification classification = default(Classification), TransferableString value = default(TransferableString))
        {
            // to ensure "classification" is required (not null)
            if (classification == null)
            {
                throw new ArgumentNullException("classification is a required property for BrowserSelection and cannot be null");
            }
            this.Classification = classification;
            // to ensure "value" is required (not null)
            if (value == null)
            {
                throw new ArgumentNullException("value is a required property for BrowserSelection and cannot be null");
            }
            this.Value = value;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", IsRequired = true, EmitDefaultValue = true)]
        public Classification Classification { get; set; }

        /// <summary>
        /// Gets or Sets Value
        /// </summary>
        [DataMember(Name = "value", IsRequired = true, EmitDefaultValue = true)]
        public TransferableString Value { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class BrowserSelection {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Value: ").Append(Value).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
