/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// User Metadata from Auth0
    /// </summary>
    [DataContract(Name = "Auth0UserMetadata")]
    public partial class Auth0UserMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0UserMetadata" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Auth0UserMetadata() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0UserMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="globalId">globalId (required).</param>
        /// <param name="cloudKey">cloudKey.</param>
        /// <param name="stripeCustomerId">A customer ID that is added to the user in the case of payments.</param>
        /// <param name="vanityname">this is the vanityname of the user.(set from their custom CNAME dns record.) ie mark.pieces.cloud where \&quot;mark\&quot; is the vanityname..</param>
        /// <param name="allocation">allocation.</param>
        /// <param name="openAI">openAI.</param>
        /// <param name="beta">beta.</param>
        public Auth0UserMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Guid globalId = default(Guid), string cloudKey = default(string), string stripeCustomerId = default(string), string vanityname = default(string), Auth0UserAllocationMetadata allocation = default(Auth0UserAllocationMetadata), Auth0OpenAIUserMetadata openAI = default(Auth0OpenAIUserMetadata), AnonymousTemporalRange beta = default(AnonymousTemporalRange))
        {
            this.GlobalId = globalId;
            this.Schema = schema;
            this.CloudKey = cloudKey;
            this.StripeCustomerId = stripeCustomerId;
            this.Vanityname = vanityname;
            this.Allocation = allocation;
            this.OpenAI = openAI;
            this.Beta = beta;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets GlobalId
        /// </summary>
        [DataMember(Name = "global_id", IsRequired = true, EmitDefaultValue = true)]
        public Guid GlobalId { get; set; }

        /// <summary>
        /// Gets or Sets CloudKey
        /// </summary>
        [DataMember(Name = "cloud_key", EmitDefaultValue = false)]
        public string CloudKey { get; set; }

        /// <summary>
        /// A customer ID that is added to the user in the case of payments
        /// </summary>
        /// <value>A customer ID that is added to the user in the case of payments</value>
        [DataMember(Name = "stripe_customer_id", EmitDefaultValue = false)]
        public string StripeCustomerId { get; set; }

        /// <summary>
        /// this is the vanityname of the user.(set from their custom CNAME dns record.) ie mark.pieces.cloud where \&quot;mark\&quot; is the vanityname.
        /// </summary>
        /// <value>this is the vanityname of the user.(set from their custom CNAME dns record.) ie mark.pieces.cloud where \&quot;mark\&quot; is the vanityname.</value>
        [DataMember(Name = "vanityname", EmitDefaultValue = false)]
        public string Vanityname { get; set; }

        /// <summary>
        /// Gets or Sets Allocation
        /// </summary>
        [DataMember(Name = "allocation", EmitDefaultValue = false)]
        public Auth0UserAllocationMetadata Allocation { get; set; }

        /// <summary>
        /// Gets or Sets OpenAI
        /// </summary>
        [DataMember(Name = "open_AI", EmitDefaultValue = false)]
        public Auth0OpenAIUserMetadata OpenAI { get; set; }

        /// <summary>
        /// Gets or Sets Beta
        /// </summary>
        [DataMember(Name = "beta", EmitDefaultValue = false)]
        public AnonymousTemporalRange Beta { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Auth0UserMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  GlobalId: ").Append(GlobalId).Append("\n");
            sb.Append("  CloudKey: ").Append(CloudKey).Append("\n");
            sb.Append("  StripeCustomerId: ").Append(StripeCustomerId).Append("\n");
            sb.Append("  Vanityname: ").Append(Vanityname).Append("\n");
            sb.Append("  Allocation: ").Append(Allocation).Append("\n");
            sb.Append("  OpenAI: ").Append(OpenAI).Append("\n");
            sb.Append("  Beta: ").Append(Beta).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
