/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is specifically for our allocation server metadata.
    /// </summary>
    [DataContract(Name = "Auth0UserAllocationMetadata")]
    public partial class Auth0UserAllocationMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0UserAllocationMetadata" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Auth0UserAllocationMetadata() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0UserAllocationMetadata" /> class.
        /// </summary>
        /// <param name="project">project (required).</param>
        /// <param name="region">region (required).</param>
        public Auth0UserAllocationMetadata(string project = default(string), string region = default(string))
        {
            // to ensure "project" is required (not null)
            if (project == null)
            {
                throw new ArgumentNullException("project is a required property for Auth0UserAllocationMetadata and cannot be null");
            }
            this.Project = project;
            // to ensure "region" is required (not null)
            if (region == null)
            {
                throw new ArgumentNullException("region is a required property for Auth0UserAllocationMetadata and cannot be null");
            }
            this.Region = region;
        }

        /// <summary>
        /// Gets or Sets Project
        /// </summary>
        [DataMember(Name = "project", IsRequired = true, EmitDefaultValue = true)]
        public string Project { get; set; }

        /// <summary>
        /// Gets or Sets Region
        /// </summary>
        [DataMember(Name = "region", IsRequired = true, EmitDefaultValue = true)]
        public string Region { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Auth0UserAllocationMetadata {\n");
            sb.Append("  Project: ").Append(Project).Append("\n");
            sb.Append("  Region: ").Append(Region).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
