/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// The redirect URI for you Auth 0 Service
    /// </summary>
    [DataContract(Name = "Auth0_redirects")]
    public partial class Auth0Redirects : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0Redirects" /> class.
        /// </summary>
        /// <param name="authenticated">Where the Auth0 redirects after the user is authorized.</param>
        /// <param name="unauthenticated">The redirect where a user returns once unauthenticated.</param>
        public Auth0Redirects(string authenticated = default(string), string unauthenticated = default(string))
        {
            this.Authenticated = authenticated;
            this.Unauthenticated = unauthenticated;
        }

        /// <summary>
        /// Where the Auth0 redirects after the user is authorized
        /// </summary>
        /// <value>Where the Auth0 redirects after the user is authorized</value>
        [DataMember(Name = "authenticated", EmitDefaultValue = false)]
        public string Authenticated { get; set; }

        /// <summary>
        /// The redirect where a user returns once unauthenticated
        /// </summary>
        /// <value>The redirect where a user returns once unauthenticated</value>
        [DataMember(Name = "unauthenticated", EmitDefaultValue = false)]
        public string Unauthenticated { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Auth0Redirects {\n");
            sb.Append("  Authenticated: ").Append(Authenticated).Append("\n");
            sb.Append("  Unauthenticated: ").Append(Unauthenticated).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
