/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Only supporting a single api key per user.
    /// </summary>
    [DataContract(Name = "Auth0OpenAIUserMetadata")]
    public partial class Auth0OpenAIUserMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0OpenAIUserMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="apiKey">apiKey.</param>
        /// <param name="apiKeyName">apiKeyName.</param>
        /// <param name="organizationKey">organizationKey.</param>
        public Auth0OpenAIUserMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string apiKey = default(string), string apiKeyName = default(string), string organizationKey = default(string))
        {
            this.Schema = schema;
            this.ApiKey = apiKey;
            this.ApiKeyName = apiKeyName;
            this.OrganizationKey = organizationKey;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets ApiKey
        /// </summary>
        [DataMember(Name = "api_key", EmitDefaultValue = false)]
        public string ApiKey { get; set; }

        /// <summary>
        /// Gets or Sets ApiKeyName
        /// </summary>
        [DataMember(Name = "api_key_name", EmitDefaultValue = false)]
        public string ApiKeyName { get; set; }

        /// <summary>
        /// Gets or Sets OrganizationKey
        /// </summary>
        [DataMember(Name = "organization_key", EmitDefaultValue = false)]
        public string OrganizationKey { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Auth0OpenAIUserMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  ApiKey: ").Append(ApiKey).Append("\n");
            sb.Append("  ApiKeyName: ").Append(ApiKeyName).Append("\n");
            sb.Append("  OrganizationKey: ").Append(OrganizationKey).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
