/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// you will have at minimum 2 urls,  base: is the default url of your cloud.  id: is the branded url, uuid.pieces.cloud.  (optional) vanity: is the custom branded url, mark.pieces.cloud
    /// </summary>
    [DataContract(Name = "AllocationCloudUrls")]
    public partial class AllocationCloudUrls : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloudUrls" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected AllocationCloudUrls() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloudUrls" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="varBase">varBase (required).</param>
        /// <param name="id">id (required).</param>
        /// <param name="vanity">vanity.</param>
        public AllocationCloudUrls(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AllocationCloudUrl varBase = default(AllocationCloudUrl), AllocationCloudUrl id = default(AllocationCloudUrl), AllocationCloudUrl vanity = default(AllocationCloudUrl))
        {
            // to ensure "varBase" is required (not null)
            if (varBase == null)
            {
                throw new ArgumentNullException("varBase is a required property for AllocationCloudUrls and cannot be null");
            }
            this.Base = varBase;
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for AllocationCloudUrls and cannot be null");
            }
            this.Id = id;
            this.Schema = schema;
            this.Vanity = vanity;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Base
        /// </summary>
        [DataMember(Name = "base", IsRequired = true, EmitDefaultValue = true)]
        public AllocationCloudUrl Base { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public AllocationCloudUrl Id { get; set; }

        /// <summary>
        /// Gets or Sets Vanity
        /// </summary>
        [DataMember(Name = "vanity", EmitDefaultValue = false)]
        public AllocationCloudUrl Vanity { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class AllocationCloudUrls {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Base: ").Append(Base).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Vanity: ").Append(Vanity).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
