/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is one of the 3 possible urls that will route to your cloud :).
    /// </summary>
    [DataContract(Name = "AllocationCloudUrl")]
    public partial class AllocationCloudUrl : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Status
        /// </summary>
        [DataMember(Name = "status", IsRequired = true, EmitDefaultValue = true)]
        public AllocationStatusEnum Status { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloudUrl" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected AllocationCloudUrl() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloudUrl" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="status">status (required).</param>
        /// <param name="url">this is the base url that is used to communicat with your vpc. (required).</param>
        public AllocationCloudUrl(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AllocationStatusEnum status = default(AllocationStatusEnum), string url = default(string))
        {
            this.Status = status;
            // to ensure "url" is required (not null)
            if (url == null)
            {
                throw new ArgumentNullException("url is a required property for AllocationCloudUrl and cannot be null");
            }
            this.Url = url;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// this is the base url that is used to communicat with your vpc.
        /// </summary>
        /// <value>this is the base url that is used to communicat with your vpc.</value>
        [DataMember(Name = "url", IsRequired = true, EmitDefaultValue = true)]
        public string Url { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class AllocationCloudUrl {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
