/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// update &amp;&amp; version: will be present only if your cloud was successfully spun up &amp;&amp; running.  updated: is the last time this was updated.
    /// </summary>
    [DataContract(Name = "AllocationCloud")]
    public partial class AllocationCloud : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloud" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected AllocationCloud() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="AllocationCloud" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">This is a uuid that represents this cloud.(this is the same as the userid) (required).</param>
        /// <param name="user">this is your useruuid. (required).</param>
        /// <param name="urls">urls (required).</param>
        /// <param name="status">status (required).</param>
        /// <param name="project">This is the project that this is attached to. (required).</param>
        /// <param name="updated">updated.</param>
        /// <param name="varVersion">this is the current version of the server..</param>
        /// <param name="region">this is the region where the project is defined..</param>
        public AllocationCloud(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string user = default(string), AllocationCloudUrls urls = default(AllocationCloudUrls), AllocationCloudStatus status = default(AllocationCloudStatus), string project = default(string), GroupedTimestamp updated = default(GroupedTimestamp), string varVersion = default(string), string region = default(string))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for AllocationCloud and cannot be null");
            }
            this.Id = id;
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for AllocationCloud and cannot be null");
            }
            this.User = user;
            // to ensure "urls" is required (not null)
            if (urls == null)
            {
                throw new ArgumentNullException("urls is a required property for AllocationCloud and cannot be null");
            }
            this.Urls = urls;
            // to ensure "status" is required (not null)
            if (status == null)
            {
                throw new ArgumentNullException("status is a required property for AllocationCloud and cannot be null");
            }
            this.Status = status;
            // to ensure "project" is required (not null)
            if (project == null)
            {
                throw new ArgumentNullException("project is a required property for AllocationCloud and cannot be null");
            }
            this.Project = project;
            this.Schema = schema;
            this.Updated = updated;
            this.VarVersion = varVersion;
            this.Region = region;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is a uuid that represents this cloud.(this is the same as the userid)
        /// </summary>
        /// <value>This is a uuid that represents this cloud.(this is the same as the userid)</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// this is your useruuid.
        /// </summary>
        /// <value>this is your useruuid.</value>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets Urls
        /// </summary>
        [DataMember(Name = "urls", IsRequired = true, EmitDefaultValue = true)]
        public AllocationCloudUrls Urls { get; set; }

        /// <summary>
        /// Gets or Sets Status
        /// </summary>
        [DataMember(Name = "status", IsRequired = true, EmitDefaultValue = true)]
        public AllocationCloudStatus Status { get; set; }

        /// <summary>
        /// This is the project that this is attached to.
        /// </summary>
        /// <value>This is the project that this is attached to.</value>
        [DataMember(Name = "project", IsRequired = true, EmitDefaultValue = true)]
        public string Project { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", EmitDefaultValue = false)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// this is the current version of the server.
        /// </summary>
        /// <value>this is the current version of the server.</value>
        [DataMember(Name = "version", EmitDefaultValue = false)]
        public string VarVersion { get; set; }

        /// <summary>
        /// this is the region where the project is defined.
        /// </summary>
        /// <value>this is the region where the project is defined.</value>
        [DataMember(Name = "region", EmitDefaultValue = false)]
        public string Region { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class AllocationCloud {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Urls: ").Append(Urls).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            sb.Append("  Project: ").Append(Project).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  VarVersion: ").Append(VarVersion).Append("\n");
            sb.Append("  Region: ").Append(Region).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
