/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// These are aesthetics properties that will ensure the darkmode + font size and other aesthetics properties persist:)
    /// </summary>
    [DataContract(Name = "Aesthetics")]
    public partial class Aesthetics : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Aesthetics" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Aesthetics() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Aesthetics" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="theme">theme (required).</param>
        /// <param name="font">font (required).</param>
        public Aesthetics(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Theme theme = default(Theme), Font font = default(Font))
        {
            // to ensure "theme" is required (not null)
            if (theme == null)
            {
                throw new ArgumentNullException("theme is a required property for Aesthetics and cannot be null");
            }
            this.Theme = theme;
            // to ensure "font" is required (not null)
            if (font == null)
            {
                throw new ArgumentNullException("font is a required property for Aesthetics and cannot be null");
            }
            this.Font = font;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Theme
        /// </summary>
        [DataMember(Name = "theme", IsRequired = true, EmitDefaultValue = true)]
        public Theme Theme { get; set; }

        /// <summary>
        /// Gets or Sets Font
        /// </summary>
        [DataMember(Name = "font", IsRequired = true, EmitDefaultValue = true)]
        public Font Font { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Aesthetics {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Theme: ").Append(Theme).Append("\n");
            sb.Append("  Font: ").Append(Font).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
