/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamPatternEngineApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST]
        /// </summary>
        /// <remarks>
        /// This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamIngestion</returns>
        WorkstreamIngestion WorkstreamPatternEngineCreateIngestion(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST]
        /// </summary>
        /// <remarks>
        /// This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamIngestion</returns>
        ApiResponse<WorkstreamIngestion> WorkstreamPatternEngineCreateIngestionWithHttpInfo(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET]
        /// </summary>
        /// <remarks>
        /// This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineSources</returns>
        WorkstreamPatternEngineSources WorkstreamPatternEngineProcessorsSources(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET]
        /// </summary>
        /// <remarks>
        /// This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineSources</returns>
        ApiResponse<WorkstreamPatternEngineSources> WorkstreamPatternEngineProcessorsSourcesWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST]
        /// </summary>
        /// <remarks>
        /// This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionActivate(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST]
        /// </summary>
        /// <remarks>
        /// This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfo(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST]
        /// </summary>
        /// <remarks>
        /// This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibration</returns>
        WorkstreamPatternEngineVisionCalibration WorkstreamPatternEngineProcessorsVisionCalibrationCapture(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST]
        /// </summary>
        /// <remarks>
        /// This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibration</returns>
        ApiResponse<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET]
        /// </summary>
        /// <remarks>
        /// This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibration</returns>
        WorkstreamPatternEngineVisionCalibration WorkstreamPatternEngineProcessorsVisionCalibrationsFocused(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET]
        /// </summary>
        /// <remarks>
        /// This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibration</returns>
        ApiResponse<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibrations</returns>
        WorkstreamPatternEngineVisionCalibrations WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibrations</returns>
        ApiResponse<WorkstreamPatternEngineVisionCalibrations> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST]
        /// </summary>
        /// <remarks>
        /// This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void WorkstreamPatternEngineProcessorsVisionDataClear(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST]
        /// </summary>
        /// <remarks>
        /// This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfo(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST]
        /// </summary>
        /// <remarks>
        /// This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionDeactivate(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST]
        /// </summary>
        /// <remarks>
        /// This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfo(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will delete a single event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent(string visionEvent, int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will delete a single event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfo(string visionEvent, int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove the UUIDs that were removed from the qdrant event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>FlattenedWorkstreamPatternEngineVisionEvents</returns>
        FlattenedWorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsScopedDelete(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove the UUIDs that were removed from the qdrant event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of FlattenedWorkstreamPatternEngineVisionEvents</returns>
        ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfo(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedWorkstreamPatternEngineVisionEvents</returns>
        SearchedWorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsSearch(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedWorkstreamPatternEngineVisionEvents</returns>
        ApiResponse<SearchedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfo(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionEvents</returns>
        WorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsSnapshot(bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionEvents</returns>
        ApiResponse<WorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfo(bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will return a specific event from the WPE.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionEvent</returns>
        WorkstreamPatternEngineVisionEvent WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will return a specific event from the WPE.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionEvent</returns>
        ApiResponse<WorkstreamPatternEngineVisionEvent> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfo(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET]
        /// </summary>
        /// <remarks>
        /// This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionMetadata</returns>
        WorkstreamPatternEngineVisionMetadata WorkstreamPatternEngineProcessorsVisionMetadata(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET]
        /// </summary>
        /// <remarks>
        /// This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionMetadata</returns>
        ApiResponse<WorkstreamPatternEngineVisionMetadata> WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionStatus(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS]
        /// </summary>
        /// <remarks>
        /// This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionStatusStream(int operationIndex = 0);

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS]
        /// </summary>
        /// <remarks>
        /// This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfo(int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamPatternEngineApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST]
        /// </summary>
        /// <remarks>
        /// This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamIngestion</returns>
        System.Threading.Tasks.Task<WorkstreamIngestion> WorkstreamPatternEngineCreateIngestionAsync(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST]
        /// </summary>
        /// <remarks>
        /// This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamIngestion)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamIngestion>> WorkstreamPatternEngineCreateIngestionWithHttpInfoAsync(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET]
        /// </summary>
        /// <remarks>
        /// This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineSources</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineSources> WorkstreamPatternEngineProcessorsSourcesAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET]
        /// </summary>
        /// <remarks>
        /// This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineSources)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineSources>> WorkstreamPatternEngineProcessorsSourcesWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST]
        /// </summary>
        /// <remarks>
        /// This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionActivateAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST]
        /// </summary>
        /// <remarks>
        /// This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfoAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST]
        /// </summary>
        /// <remarks>
        /// This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibration</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST]
        /// </summary>
        /// <remarks>
        /// This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibration)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionCalibration>> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET]
        /// </summary>
        /// <remarks>
        /// This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibration</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET]
        /// </summary>
        /// <remarks>
        /// This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibration)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionCalibration>> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibrations</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibrations> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibrations)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionCalibrations>> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST]
        /// </summary>
        /// <remarks>
        /// This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task WorkstreamPatternEngineProcessorsVisionDataClearAsync(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST]
        /// </summary>
        /// <remarks>
        /// This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfoAsync(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST]
        /// </summary>
        /// <remarks>
        /// This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionDeactivateAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST]
        /// </summary>
        /// <remarks>
        /// This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfoAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will delete a single event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventAsync(string visionEvent, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will delete a single event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfoAsync(string visionEvent, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove the UUIDs that were removed from the qdrant event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of FlattenedWorkstreamPatternEngineVisionEvents</returns>
        System.Threading.Tasks.Task<FlattenedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteAsync(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove the UUIDs that were removed from the qdrant event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (FlattenedWorkstreamPatternEngineVisionEvents)</returns>
        System.Threading.Tasks.Task<ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfoAsync(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedWorkstreamPatternEngineVisionEvents</returns>
        System.Threading.Tasks.Task<SearchedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSearchAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedWorkstreamPatternEngineVisionEvents)</returns>
        System.Threading.Tasks.Task<ApiResponse<SearchedWorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfoAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionEvents</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSnapshotAsync(bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET]
        /// </summary>
        /// <remarks>
        /// This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionEvents)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfoAsync(bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will return a specific event from the WPE.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionEvent</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionEvent> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotAsync(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will return a specific event from the WPE.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionEvent)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionEvent>> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfoAsync(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET]
        /// </summary>
        /// <remarks>
        /// This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionMetadata</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineVisionMetadata> WorkstreamPatternEngineProcessorsVisionMetadataAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET]
        /// </summary>
        /// <remarks>
        /// This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionMetadata)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineVisionMetadata>> WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS]
        /// </summary>
        /// <remarks>
        /// This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusStreamAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS]
        /// </summary>
        /// <remarks>
        /// This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamPatternEngineApi : IWorkstreamPatternEngineApiSync, IWorkstreamPatternEngineApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class WorkstreamPatternEngineApi : IWorkstreamPatternEngineApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineApi"/> class.
        /// </summary>
        /// <returns></returns>
        public WorkstreamPatternEngineApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineApi"/> class.
        /// </summary>
        /// <returns></returns>
        public WorkstreamPatternEngineApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public WorkstreamPatternEngineApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public WorkstreamPatternEngineApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST] This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamIngestion</returns>
        public WorkstreamIngestion WorkstreamPatternEngineCreateIngestion(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamIngestion> localVarResponse = WorkstreamPatternEngineCreateIngestionWithHttpInfo(seededWorkstreamIngestion);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST] This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamIngestion</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamIngestion> WorkstreamPatternEngineCreateIngestionWithHttpInfo(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededWorkstreamIngestion;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineCreateIngestion";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<WorkstreamIngestion>("/workstream_pattern_engine/ingestions/create", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineCreateIngestion", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST] This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamIngestion</returns>
        public async System.Threading.Tasks.Task<WorkstreamIngestion> WorkstreamPatternEngineCreateIngestionAsync(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamIngestion> localVarResponse = await WorkstreamPatternEngineCreateIngestionWithHttpInfoAsync(seededWorkstreamIngestion, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/ingestions/create [POST] This will take in events from plugins that will be used to drive data to be displayed in the feed.  This is not guaranteed to display information that is taken into this endpoint in the feed.  We take a subset of the information provided in this endpoint + information from the WPE to curated a highly relevant Heads up display of useful materials.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededWorkstreamIngestion"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamIngestion)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamIngestion>> WorkstreamPatternEngineCreateIngestionWithHttpInfoAsync(SeededWorkstreamIngestion seededWorkstreamIngestion = default(SeededWorkstreamIngestion), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededWorkstreamIngestion;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineCreateIngestion";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<WorkstreamIngestion>("/workstream_pattern_engine/ingestions/create", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineCreateIngestion", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET] This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineSources</returns>
        public WorkstreamPatternEngineSources WorkstreamPatternEngineProcessorsSources(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineSources> localVarResponse = WorkstreamPatternEngineProcessorsSourcesWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET] This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineSources</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineSources> WorkstreamPatternEngineProcessorsSourcesWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsSources";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineSources>("/workstream_pattern_engine/processors/sources", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsSources", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET] This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineSources</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineSources> WorkstreamPatternEngineProcessorsSourcesAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineSources> localVarResponse = await WorkstreamPatternEngineProcessorsSourcesWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/sources [GET] This will return all of the applications(focused windows) that have events saved within WPE qdrant collection.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineSources)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineSources>> WorkstreamPatternEngineProcessorsSourcesWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsSources";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineSources>("/workstream_pattern_engine/processors/sources", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsSources", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST] This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        public WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionActivate(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfo(workstreamPatternEngineStatus);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST] This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfo(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineStatus;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionActivate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/activate", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionActivate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST] This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionActivateAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = await WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfoAsync(workstreamPatternEngineStatus, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/activate [POST] This will activate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionActivateWithHttpInfoAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineStatus;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionActivate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/activate", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionActivate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST] This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibration</returns>
        public WorkstreamPatternEngineVisionCalibration WorkstreamPatternEngineProcessorsVisionCalibrationCapture(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> localVarResponse = WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST] This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibration</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationCapture";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<WorkstreamPatternEngineVisionCalibration>("/workstream_pattern_engine/processors/vision/calibration/capture", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationCapture", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST] This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibration</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> localVarResponse = await WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibration/capture [POST] This will attempt to capture the copilot/feed/xyz dimensions of current focused window  note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibration)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration>> WorkstreamPatternEngineProcessorsVisionCalibrationCaptureWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationCapture";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<WorkstreamPatternEngineVisionCalibration>("/workstream_pattern_engine/processors/vision/calibration/capture", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationCapture", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET] This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibration</returns>
        public WorkstreamPatternEngineVisionCalibration WorkstreamPatternEngineProcessorsVisionCalibrationsFocused(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> localVarResponse = WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET] This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibration</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationsFocused";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineVisionCalibration>("/workstream_pattern_engine/processors/vision/calibrations/focused", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationsFocused", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET] This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibration</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibration> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration> localVarResponse = await WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations/focused [GET] This will get the copilot/feed/xyz dimensions of the focused window.  This endpoint will attempt to do the following: 1. get the focus window 2. we will do a lookup to see if we have the copilot/feed/xyz dimension for this window if not we will return null if so we will return the dimensions as well as when the dimensions were taken  note: in the future we can make a differentiation of the dimensions based on the type of qrCode. note: no need to pass in the window name: b/c we will just get the focused window note: we will also return the window name in the returnable so the dev can verify this is the window of the plugin.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibration)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibration>> WorkstreamPatternEngineProcessorsVisionCalibrationsFocusedWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationsFocused";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineVisionCalibration>("/workstream_pattern_engine/processors/vision/calibrations/focused", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationsFocused", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET] This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionCalibrations</returns>
        public WorkstreamPatternEngineVisionCalibrations WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibrations> localVarResponse = WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET] This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionCalibrations</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibrations> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineVisionCalibrations>("/workstream_pattern_engine/processors/vision/calibrations", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET] This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionCalibrations</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionCalibrations> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibrations> localVarResponse = await WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/calibrations [GET] This will return a snapshot of all of our captured copilot window Dimensions   note: this will return many captures note: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz) note: in the future we can make a differentiation of the dimensions based on the type of qrCode.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionCalibrations)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionCalibrations>> WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshotWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineVisionCalibrations>("/workstream_pattern_engine/processors/vision/calibrations", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST] This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void WorkstreamPatternEngineProcessorsVisionDataClear(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0)
        {
            WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfo(workstreamPatternEngineDataCleanupRequest);
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST] This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfo(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineDataCleanupRequest;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionDataClear";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/workstream_pattern_engine/processors/vision/data/clear", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionDataClear", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST] This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task WorkstreamPatternEngineProcessorsVisionDataClearAsync(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfoAsync(workstreamPatternEngineDataCleanupRequest, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/clear [POST] This will clear the data for the Workstream Pattern Engine, specifically for our vision data.  This boy will accept ranges of time that the user wants to remove the processing from.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineDataCleanupRequest"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> WorkstreamPatternEngineProcessorsVisionDataClearWithHttpInfoAsync(WorkstreamPatternEngineDataCleanupRequest workstreamPatternEngineDataCleanupRequest = default(WorkstreamPatternEngineDataCleanupRequest), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineDataCleanupRequest;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionDataClear";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/workstream_pattern_engine/processors/vision/data/clear", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionDataClear", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST] This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        public WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionDeactivate(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfo(workstreamPatternEngineStatus);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST] This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfo(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineStatus;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionDeactivate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/deactivate", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionDeactivate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST] This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionDeactivateAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = await WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfoAsync(workstreamPatternEngineStatus, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/deactivate [POST] This will deactivate your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineStatus"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionDeactivateWithHttpInfoAsync(WorkstreamPatternEngineStatus workstreamPatternEngineStatus = default(WorkstreamPatternEngineStatus), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineStatus;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionDeactivate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/deactivate", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionDeactivate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST] This will delete a single event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent(string visionEvent, int operationIndex = 0)
        {
            WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfo(visionEvent);
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST] This will delete a single event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfo(string visionEvent, int operationIndex = 0)
        {
            // verify the required parameter 'visionEvent' is set
            if (visionEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'visionEvent' when calling WorkstreamPatternEngineApi->WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("vision_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(visionEvent)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/workstream_pattern_engine/processors/vision/data/events/{vision_event}/delete", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST] This will delete a single event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventAsync(string visionEvent, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfoAsync(visionEvent, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST] This will delete a single event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEventWithHttpInfoAsync(string visionEvent, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'visionEvent' is set
            if (visionEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'visionEvent' when calling WorkstreamPatternEngineApi->WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("vision_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(visionEvent)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/workstream_pattern_engine/processors/vision/data/events/{vision_event}/delete", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST] This will remove the UUIDs that were removed from the qdrant event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>FlattenedWorkstreamPatternEngineVisionEvents</returns>
        public FlattenedWorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsScopedDelete(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents> localVarResponse = WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfo(workstreamPatternEngineVisionEventDeletions);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST] This will remove the UUIDs that were removed from the qdrant event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of FlattenedWorkstreamPatternEngineVisionEvents</returns>
        public Pieces.Os.Core.Client.ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfo(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineVisionEventDeletions;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsScopedDelete";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<FlattenedWorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events/scoped_delete", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsScopedDelete", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST] This will remove the UUIDs that were removed from the qdrant event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of FlattenedWorkstreamPatternEngineVisionEvents</returns>
        public async System.Threading.Tasks.Task<FlattenedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteAsync(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents> localVarResponse = await WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfoAsync(workstreamPatternEngineVisionEventDeletions, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/events/scoped_delete [POST] This will remove the UUIDs that were removed from the qdrant event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamPatternEngineVisionEventDeletions"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (FlattenedWorkstreamPatternEngineVisionEvents)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<FlattenedWorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsScopedDeleteWithHttpInfoAsync(WorkstreamPatternEngineVisionEventDeletions workstreamPatternEngineVisionEventDeletions = default(WorkstreamPatternEngineVisionEventDeletions), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = workstreamPatternEngineVisionEventDeletions;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsScopedDelete";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<FlattenedWorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events/scoped_delete", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsScopedDelete", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST] This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedWorkstreamPatternEngineVisionEvents</returns>
        public SearchedWorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsSearch(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedWorkstreamPatternEngineVisionEvents> localVarResponse = WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfo(transferables, searchInput);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST] This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedWorkstreamPatternEngineVisionEvents</returns>
        public Pieces.Os.Core.Client.ApiResponse<SearchedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfo(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSearch";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<SearchedWorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events/search", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSearch", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST] This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedWorkstreamPatternEngineVisionEvents</returns>
        public async System.Threading.Tasks.Task<SearchedWorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSearchAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedWorkstreamPatternEngineVisionEvents> localVarResponse = await WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfoAsync(transferables, searchInput, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/search [POST] This will search your WPE events and will return a list of events that match the query/timestamp range/list of applications
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedWorkstreamPatternEngineVisionEvents)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<SearchedWorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsSearchWithHttpInfoAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSearch";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<SearchedWorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events/search", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSearch", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET] This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionEvents</returns>
        public WorkstreamPatternEngineVisionEvents WorkstreamPatternEngineProcessorsVisionEventsSnapshot(bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvents> localVarResponse = WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfo(transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET] This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionEvents</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfo(bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET] This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionEvents</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionEvents> WorkstreamPatternEngineProcessorsVisionEventsSnapshotAsync(bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvents> localVarResponse = await WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfoAsync(transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events [GET] This will return a snapshot of all of the WPE qdrant events  note: if the transferables: are true then we will provide values for each of our events otherwise       we will just provide basic metadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionEvents)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvents>> WorkstreamPatternEngineProcessorsVisionEventsSnapshotWithHttpInfoAsync(bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineVisionEvents>("/workstream_pattern_engine/processors/vision/data/events", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET] This will return a specific event from the WPE.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionEvent</returns>
        public WorkstreamPatternEngineVisionEvent WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvent> localVarResponse = WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfo(visionEvent, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET] This will return a specific event from the WPE.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionEvent</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvent> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfo(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'visionEvent' is set
            if (visionEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'visionEvent' when calling WorkstreamPatternEngineApi->WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("vision_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(visionEvent)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineVisionEvent>("/workstream_pattern_engine/processors/vision/data/events/{vision_event}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET] This will return a specific event from the WPE.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionEvent</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionEvent> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotAsync(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvent> localVarResponse = await WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfoAsync(visionEvent, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET] This will return a specific event from the WPE.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="visionEvent">This is a identifier that is used to identify a specific WPE_vision event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionEvent)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionEvent>> WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshotWithHttpInfoAsync(string visionEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'visionEvent' is set
            if (visionEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'visionEvent' when calling WorkstreamPatternEngineApi->WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("vision_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(visionEvent)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineVisionEvent>("/workstream_pattern_engine/processors/vision/data/events/{vision_event}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET] This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineVisionMetadata</returns>
        public WorkstreamPatternEngineVisionMetadata WorkstreamPatternEngineProcessorsVisionMetadata(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionMetadata> localVarResponse = WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET] This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineVisionMetadata</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionMetadata> WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionMetadata";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineVisionMetadata>("/workstream_pattern_engine/processors/vision/metadata", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionMetadata", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET] This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineVisionMetadata</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineVisionMetadata> WorkstreamPatternEngineProcessorsVisionMetadataAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionMetadata> localVarResponse = await WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/metadata [GET] This is an endpoint that will return the metadata of the vision data (WPE qdrant size)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineVisionMetadata)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineVisionMetadata>> WorkstreamPatternEngineProcessorsVisionMetadataWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionMetadata";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineVisionMetadata>("/workstream_pattern_engine/processors/vision/metadata", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionMetadata", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET] This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        public WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionStatus(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET] This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/status", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET] This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = await WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status [GET] This will get a snapshot of the status your Workstream Pattern Engine. This is used to aggregate information on your user&#39;s desktop, specifically recording the application in focus and aggregating relevant context that will then be used to ground the copilot conversations, as well as the feed.  Note: required to be a beta user to use this feature until this is live(roughly mid to late April)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionStatusWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/status", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS] This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamPatternEngineStatus</returns>
        public WorkstreamPatternEngineStatus WorkstreamPatternEngineProcessorsVisionStatusStream(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS] This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamPatternEngineStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionStatusStream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/status/stream", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionStatusStream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS] This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamPatternEngineStatus</returns>
        public async System.Threading.Tasks.Task<WorkstreamPatternEngineStatus> WorkstreamPatternEngineProcessorsVisionStatusStreamAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus> localVarResponse = await WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_pattern_engine/processors/vision/status/steam [WS] This is a websocket for the status of the workstream pattern engine for vision.  This will emit an event when this is first connected to, and will emit an event when every this value changes  This will emit a \&quot;WorkstreamPatternEngineStatus\&quot; Model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamPatternEngineStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamPatternEngineStatus>> WorkstreamPatternEngineProcessorsVisionStatusStreamWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "WorkstreamPatternEngineApi.WorkstreamPatternEngineProcessorsVisionStatusStream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamPatternEngineStatus>("/workstream_pattern_engine/processors/vision/status/stream", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamPatternEngineProcessorsVisionStatusStream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
