/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamEventApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void WorkstreamEventAssociateWorkstreamSummary(string workstreamEvent, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> WorkstreamEventAssociateWorkstreamSummaryWithHttpInfo(string workstreamEvent, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void WorkstreamEventDisassociateWorkstreamSummary(string workstreamEvent, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfo(string workstreamEvent, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void WorkstreamEventScoresIncrement(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> WorkstreamEventScoresIncrementWithHttpInfo(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /workstream_event/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamEvent</returns>
        WorkstreamEvent WorkstreamEventUpdate(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0);

        /// <summary>
        /// /workstream_event/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamEvent</returns>
        ApiResponse<WorkstreamEvent> WorkstreamEventUpdateWithHttpInfo(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0);
        /// <summary>
        /// /workstream_event/{workstream_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamEvent</returns>
        WorkstreamEvent WorkstreamEventsSpecificWorkstreamEventSnapshot(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /workstream_event/{workstream_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamEvent</returns>
        ApiResponse<WorkstreamEvent> WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfo(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamEventApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task WorkstreamEventAssociateWorkstreamSummaryAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> WorkstreamEventAssociateWorkstreamSummaryWithHttpInfoAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task WorkstreamEventDisassociateWorkstreamSummaryAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfoAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task WorkstreamEventScoresIncrementAsync(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> WorkstreamEventScoresIncrementWithHttpInfoAsync(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_event/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamEvent</returns>
        System.Threading.Tasks.Task<WorkstreamEvent> WorkstreamEventUpdateAsync(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_event/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamEvent)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamEvent>> WorkstreamEventUpdateWithHttpInfoAsync(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /workstream_event/{workstream_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamEvent</returns>
        System.Threading.Tasks.Task<WorkstreamEvent> WorkstreamEventsSpecificWorkstreamEventSnapshotAsync(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /workstream_event/{workstream_event} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single workstream_event.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamEvent)</returns>
        System.Threading.Tasks.Task<ApiResponse<WorkstreamEvent>> WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfoAsync(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IWorkstreamEventApi : IWorkstreamEventApiSync, IWorkstreamEventApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class WorkstreamEventApi : IWorkstreamEventApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventApi"/> class.
        /// </summary>
        /// <returns></returns>
        public WorkstreamEventApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventApi"/> class.
        /// </summary>
        /// <returns></returns>
        public WorkstreamEventApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public WorkstreamEventApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public WorkstreamEventApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void WorkstreamEventAssociateWorkstreamSummary(string workstreamEvent, string workstreamSummary, int operationIndex = 0)
        {
            WorkstreamEventAssociateWorkstreamSummaryWithHttpInfo(workstreamEvent, workstreamSummary);
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> WorkstreamEventAssociateWorkstreamSummaryWithHttpInfo(string workstreamEvent, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling WorkstreamEventApi->WorkstreamEventAssociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task WorkstreamEventAssociateWorkstreamSummaryAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await WorkstreamEventAssociateWorkstreamSummaryWithHttpInfoAsync(workstreamEvent, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a workstream_event with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> WorkstreamEventAssociateWorkstreamSummaryWithHttpInfoAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling WorkstreamEventApi->WorkstreamEventAssociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void WorkstreamEventDisassociateWorkstreamSummary(string workstreamEvent, string workstreamSummary, int operationIndex = 0)
        {
            WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfo(workstreamEvent, workstreamSummary);
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfo(string workstreamEvent, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling WorkstreamEventApi->WorkstreamEventDisassociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task WorkstreamEventDisassociateWorkstreamSummaryAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfoAsync(workstreamEvent, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a workstream_event from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> WorkstreamEventDisassociateWorkstreamSummaryWithHttpInfoAsync(string workstreamEvent, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling WorkstreamEventApi->WorkstreamEventDisassociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void WorkstreamEventScoresIncrement(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            WorkstreamEventScoresIncrementWithHttpInfo(workstreamEvent, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> WorkstreamEventScoresIncrementWithHttpInfo(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/workstream_event/{workstream_event}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task WorkstreamEventScoresIncrementAsync(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await WorkstreamEventScoresIncrementWithHttpInfoAsync(workstreamEvent, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/workstream_event/{workstream_event}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> WorkstreamEventScoresIncrementWithHttpInfoAsync(string workstreamEvent, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/workstream_event/{workstream_event}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/update [POST] This will update a specific workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamEvent</returns>
        public WorkstreamEvent WorkstreamEventUpdate(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> localVarResponse = WorkstreamEventUpdateWithHttpInfo(transferables, workstreamEvent);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_event/update [POST] This will update a specific workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamEvent</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> WorkstreamEventUpdateWithHttpInfo(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = workstreamEvent;

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<WorkstreamEvent>("/workstream_event/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/update [POST] This will update a specific workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamEvent</returns>
        public async System.Threading.Tasks.Task<WorkstreamEvent> WorkstreamEventUpdateAsync(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> localVarResponse = await WorkstreamEventUpdateWithHttpInfoAsync(transferables, workstreamEvent, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_event/update [POST] This will update a specific workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="workstreamEvent"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamEvent)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent>> WorkstreamEventUpdateWithHttpInfoAsync(bool? transferables = default(bool?), WorkstreamEvent workstreamEvent = default(WorkstreamEvent), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = workstreamEvent;

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<WorkstreamEvent>("/workstream_event/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/{workstream_event} [GET] This will get a snapshot of a single workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>WorkstreamEvent</returns>
        public WorkstreamEvent WorkstreamEventsSpecificWorkstreamEventSnapshot(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> localVarResponse = WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfo(workstreamEvent, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_event/{workstream_event} [GET] This will get a snapshot of a single workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of WorkstreamEvent</returns>
        public Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfo(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventsSpecificWorkstreamEventSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventsSpecificWorkstreamEventSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<WorkstreamEvent>("/workstream_event/{workstream_event}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventsSpecificWorkstreamEventSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /workstream_event/{workstream_event} [GET] This will get a snapshot of a single workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of WorkstreamEvent</returns>
        public async System.Threading.Tasks.Task<WorkstreamEvent> WorkstreamEventsSpecificWorkstreamEventSnapshotAsync(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent> localVarResponse = await WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfoAsync(workstreamEvent, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /workstream_event/{workstream_event} [GET] This will get a snapshot of a single workstream_event.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="workstreamEvent">This is a identifier that is used to identify a specific workstream_event.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (WorkstreamEvent)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<WorkstreamEvent>> WorkstreamEventsSpecificWorkstreamEventSnapshotWithHttpInfoAsync(string workstreamEvent, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamEvent' is set
            if (workstreamEvent == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamEvent' when calling WorkstreamEventApi->WorkstreamEventsSpecificWorkstreamEventSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("workstream_event", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamEvent)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "WorkstreamEventApi.WorkstreamEventsSpecificWorkstreamEventSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<WorkstreamEvent>("/workstream_event/{workstream_event}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("WorkstreamEventsSpecificWorkstreamEventSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
