/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface ITagApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void TagAssociateAsset(Guid asset, string tag, int operationIndex = 0);

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> TagAssociateAssetWithHttpInfo(Guid asset, string tag, int operationIndex = 0);
        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void TagAssociatePerson(string tag, string person, int operationIndex = 0);

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> TagAssociatePersonWithHttpInfo(string tag, string person, int operationIndex = 0);
        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void TagDisassociateAsset(string tag, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> TagDisassociateAssetWithHttpInfo(string tag, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void TagDisassociatePerson(string tag, string person, int operationIndex = 0);

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> TagDisassociatePersonWithHttpInfo(string tag, string person, int operationIndex = 0);
        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void TagScoresIncrement(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> TagScoresIncrementWithHttpInfo(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /tag/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Tag</returns>
        Tag TagUpdate(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0);

        /// <summary>
        /// /tag/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Tag</returns>
        ApiResponse<Tag> TagUpdateWithHttpInfo(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0);
        /// <summary>
        /// /tag/{tag} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Tag</returns>
        Tag TagsSpecificTagSnapshot(string tag, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /tag/{tag} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Tag</returns>
        ApiResponse<Tag> TagsSpecificTagSnapshotWithHttpInfo(string tag, bool? transferables = default(bool?), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface ITagApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task TagAssociateAssetAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> TagAssociateAssetWithHttpInfoAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task TagAssociatePersonAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a tag with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> TagAssociatePersonWithHttpInfoAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task TagDisassociateAssetAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> TagDisassociateAssetWithHttpInfoAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task TagDisassociatePersonAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a tag from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> TagDisassociatePersonWithHttpInfoAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task TagScoresIncrementAsync(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> TagScoresIncrementWithHttpInfoAsync(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /tag/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Tag</returns>
        System.Threading.Tasks.Task<Tag> TagUpdateAsync(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Tag)</returns>
        System.Threading.Tasks.Task<ApiResponse<Tag>> TagUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /tag/{tag} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Tag</returns>
        System.Threading.Tasks.Task<Tag> TagsSpecificTagSnapshotAsync(string tag, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /tag/{tag} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific tag.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Tag)</returns>
        System.Threading.Tasks.Task<ApiResponse<Tag>> TagsSpecificTagSnapshotWithHttpInfoAsync(string tag, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface ITagApi : ITagApiSync, ITagApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class TagApi : ITagApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="TagApi"/> class.
        /// </summary>
        /// <returns></returns>
        public TagApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TagApi"/> class.
        /// </summary>
        /// <returns></returns>
        public TagApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TagApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public TagApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TagApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public TagApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST] This will associate a tag with a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void TagAssociateAsset(Guid asset, string tag, int operationIndex = 0)
        {
            TagAssociateAssetWithHttpInfo(asset, tag);
        }

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST] This will associate a tag with a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> TagAssociateAssetWithHttpInfo(Guid asset, string tag, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagAssociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/tag/{tag}/assets/associate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST] This will associate a tag with a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task TagAssociateAssetAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await TagAssociateAssetWithHttpInfoAsync(asset, tag, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /tag/{tag}/assets/associate/{asset} [POST] This will associate a tag with a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> TagAssociateAssetWithHttpInfoAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagAssociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/tag/{tag}/assets/associate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST] This will associate a tag with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void TagAssociatePerson(string tag, string person, int operationIndex = 0)
        {
            TagAssociatePersonWithHttpInfo(tag, person);
        }

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST] This will associate a tag with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> TagAssociatePersonWithHttpInfo(string tag, string person, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling TagApi->TagAssociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/tag/{tag}/persons/associate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST] This will associate a tag with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task TagAssociatePersonAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await TagAssociatePersonWithHttpInfoAsync(tag, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /tag/{tag}/persons/associate/{person} [POST] This will associate a tag with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> TagAssociatePersonWithHttpInfoAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling TagApi->TagAssociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/tag/{tag}/persons/associate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST] This will enable us to dissassociate a tag from a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void TagDisassociateAsset(string tag, Guid asset, int operationIndex = 0)
        {
            TagDisassociateAssetWithHttpInfo(tag, asset);
        }

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST] This will enable us to dissassociate a tag from a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> TagDisassociateAssetWithHttpInfo(string tag, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagDisassociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/tag/{tag}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST] This will enable us to dissassociate a tag from a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task TagDisassociateAssetAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await TagDisassociateAssetWithHttpInfoAsync(tag, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /tag/{tag}/assets/disassociate/{asset} [POST] This will enable us to dissassociate a tag from a asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> TagDisassociateAssetWithHttpInfoAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagDisassociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/tag/{tag}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST] This will enable us to dissassociate a tag from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void TagDisassociatePerson(string tag, string person, int operationIndex = 0)
        {
            TagDisassociatePersonWithHttpInfo(tag, person);
        }

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST] This will enable us to dissassociate a tag from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> TagDisassociatePersonWithHttpInfo(string tag, string person, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling TagApi->TagDisassociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/tag/{tag}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST] This will enable us to dissassociate a tag from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task TagDisassociatePersonAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await TagDisassociatePersonWithHttpInfoAsync(tag, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /tag/{tag}/persons/disassociate/{person} [POST] This will enable us to dissassociate a tag from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> TagDisassociatePersonWithHttpInfoAsync(string tag, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling TagApi->TagDisassociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "TagApi.TagDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/tag/{tag}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void TagScoresIncrement(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            TagScoresIncrementWithHttpInfo(tag, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> TagScoresIncrementWithHttpInfo(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "TagApi.TagScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/tag/{tag}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task TagScoresIncrementAsync(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await TagScoresIncrementWithHttpInfoAsync(tag, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/tag/{tag}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> TagScoresIncrementWithHttpInfoAsync(string tag, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "TagApi.TagScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/tag/{tag}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/update [POST] This will update a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Tag</returns>
        public Tag TagUpdate(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Tag> localVarResponse = TagUpdateWithHttpInfo(transferables, tag);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /tag/update [POST] This will update a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Tag</returns>
        public Pieces.Os.Core.Client.ApiResponse<Tag> TagUpdateWithHttpInfo(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = tag;

            localVarRequestOptions.Operation = "TagApi.TagUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Tag>("/tag/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/update [POST] This will update a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Tag</returns>
        public async System.Threading.Tasks.Task<Tag> TagUpdateAsync(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Tag> localVarResponse = await TagUpdateWithHttpInfoAsync(transferables, tag, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /tag/update [POST] This will update a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="tag"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Tag)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Tag>> TagUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Tag tag = default(Tag), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = tag;

            localVarRequestOptions.Operation = "TagApi.TagUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Tag>("/tag/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag} [GET] This will get a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Tag</returns>
        public Tag TagsSpecificTagSnapshot(string tag, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Tag> localVarResponse = TagsSpecificTagSnapshotWithHttpInfo(tag, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /tag/{tag} [GET] This will get a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Tag</returns>
        public Pieces.Os.Core.Client.ApiResponse<Tag> TagsSpecificTagSnapshotWithHttpInfo(string tag, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagsSpecificTagSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "TagApi.TagsSpecificTagSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Tag>("/tag/{tag}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagsSpecificTagSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /tag/{tag} [GET] This will get a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Tag</returns>
        public async System.Threading.Tasks.Task<Tag> TagsSpecificTagSnapshotAsync(string tag, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Tag> localVarResponse = await TagsSpecificTagSnapshotWithHttpInfoAsync(tag, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /tag/{tag} [GET] This will get a specific tag.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Tag)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Tag>> TagsSpecificTagSnapshotWithHttpInfoAsync(string tag, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling TagApi->TagsSpecificTagSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "TagApi.TagsSpecificTagSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Tag>("/tag/{tag}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TagsSpecificTagSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
