/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IRangeApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void RangeAssociateConversationGroundingTemporalRangeWorkstreams(string range, string conversation, int operationIndex = 0);

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(string range, string conversation, int operationIndex = 0);
        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void RangeAssociateWorkstreamSummary(string range, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> RangeAssociateWorkstreamSummaryWithHttpInfo(string range, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void RangeDisassociateConversationGroundingTemporalRangeWorkstreams(string range, string conversation, int operationIndex = 0);

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(string range, string conversation, int operationIndex = 0);
        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void RangeDisassociateWorkstreamSummary(string range, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> RangeDisassociateWorkstreamSummaryWithHttpInfo(string range, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void RangeScoresIncrement(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> RangeScoresIncrementWithHttpInfo(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /range/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Range</returns>
        Range RangeUpdate(Range range = default(Range), int operationIndex = 0);

        /// <summary>
        /// /range/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Range</returns>
        ApiResponse<Range> RangeUpdateWithHttpInfo(Range range = default(Range), int operationIndex = 0);
        /// <summary>
        /// /range/{range} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Range</returns>
        Range RangesSpecificRangeSnapshot(string range, int operationIndex = 0);

        /// <summary>
        /// /range/{range} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Range</returns>
        ApiResponse<Range> RangesSpecificRangeSnapshotWithHttpInfo(string range, int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IRangeApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task RangeAssociateConversationGroundingTemporalRangeWorkstreamsAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task RangeAssociateWorkstreamSummaryAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> RangeAssociateWorkstreamSummaryWithHttpInfoAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task RangeDisassociateConversationGroundingTemporalRangeWorkstreamsAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task RangeDisassociateWorkstreamSummaryAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> RangeDisassociateWorkstreamSummaryWithHttpInfoAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task RangeScoresIncrementAsync(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> RangeScoresIncrementWithHttpInfoAsync(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /range/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Range</returns>
        System.Threading.Tasks.Task<Range> RangeUpdateAsync(Range range = default(Range), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Range)</returns>
        System.Threading.Tasks.Task<ApiResponse<Range>> RangeUpdateWithHttpInfoAsync(Range range = default(Range), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /range/{range} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Range</returns>
        System.Threading.Tasks.Task<Range> RangesSpecificRangeSnapshotAsync(string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /range/{range} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single range.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Range)</returns>
        System.Threading.Tasks.Task<ApiResponse<Range>> RangesSpecificRangeSnapshotWithHttpInfoAsync(string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IRangeApi : IRangeApiSync, IRangeApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class RangeApi : IRangeApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="RangeApi"/> class.
        /// </summary>
        /// <returns></returns>
        public RangeApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RangeApi"/> class.
        /// </summary>
        /// <returns></returns>
        public RangeApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RangeApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public RangeApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RangeApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public RangeApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST] This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void RangeAssociateConversationGroundingTemporalRangeWorkstreams(string range, string conversation, int operationIndex = 0)
        {
            RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(range, conversation);
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST] This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(string range, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeAssociateConversationGroundingTemporalRangeWorkstreams");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling RangeApi->RangeAssociateConversationGroundingTemporalRangeWorkstreams");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeAssociateConversationGroundingTemporalRangeWorkstreams";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeAssociateConversationGroundingTemporalRangeWorkstreams", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST] This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task RangeAssociateConversationGroundingTemporalRangeWorkstreamsAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(range, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST] This will associate a range with a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> RangeAssociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeAssociateConversationGroundingTemporalRangeWorkstreams");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling RangeApi->RangeAssociateConversationGroundingTemporalRangeWorkstreams");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeAssociateConversationGroundingTemporalRangeWorkstreams";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeAssociateConversationGroundingTemporalRangeWorkstreams", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void RangeAssociateWorkstreamSummary(string range, string workstreamSummary, int operationIndex = 0)
        {
            RangeAssociateWorkstreamSummaryWithHttpInfo(range, workstreamSummary);
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> RangeAssociateWorkstreamSummaryWithHttpInfo(string range, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling RangeApi->RangeAssociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/range/{range}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task RangeAssociateWorkstreamSummaryAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await RangeAssociateWorkstreamSummaryWithHttpInfoAsync(range, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a range with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> RangeAssociateWorkstreamSummaryWithHttpInfoAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling RangeApi->RangeAssociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/range/{range}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST] This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void RangeDisassociateConversationGroundingTemporalRangeWorkstreams(string range, string conversation, int operationIndex = 0)
        {
            RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(range, conversation);
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST] This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfo(string range, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeDisassociateConversationGroundingTemporalRangeWorkstreams");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling RangeApi->RangeDisassociateConversationGroundingTemporalRangeWorkstreams");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeDisassociateConversationGroundingTemporalRangeWorkstreams";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeDisassociateConversationGroundingTemporalRangeWorkstreams", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST] This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task RangeDisassociateConversationGroundingTemporalRangeWorkstreamsAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(range, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST] This will enable us to disassociate a range from a conversation(grounding.temporal.workstreams). This will do the same thing as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> RangeDisassociateConversationGroundingTemporalRangeWorkstreamsWithHttpInfoAsync(string range, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeDisassociateConversationGroundingTemporalRangeWorkstreams");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling RangeApi->RangeDisassociateConversationGroundingTemporalRangeWorkstreams");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeDisassociateConversationGroundingTemporalRangeWorkstreams";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeDisassociateConversationGroundingTemporalRangeWorkstreams", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void RangeDisassociateWorkstreamSummary(string range, string workstreamSummary, int operationIndex = 0)
        {
            RangeDisassociateWorkstreamSummaryWithHttpInfo(range, workstreamSummary);
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> RangeDisassociateWorkstreamSummaryWithHttpInfo(string range, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling RangeApi->RangeDisassociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/range/{range}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task RangeDisassociateWorkstreamSummaryAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await RangeDisassociateWorkstreamSummaryWithHttpInfoAsync(range, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a range from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> RangeDisassociateWorkstreamSummaryWithHttpInfoAsync(string range, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling RangeApi->RangeDisassociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangeDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/range/{range}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void RangeScoresIncrement(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            RangeScoresIncrementWithHttpInfo(range, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> RangeScoresIncrementWithHttpInfo(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "RangeApi.RangeScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/range/{range}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task RangeScoresIncrementAsync(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await RangeScoresIncrementWithHttpInfoAsync(range, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/range/{range}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> RangeScoresIncrementWithHttpInfoAsync(string range, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangeScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "RangeApi.RangeScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/range/{range}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/update [POST] This will update a specific range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Range</returns>
        public Range RangeUpdate(Range range = default(Range), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Range> localVarResponse = RangeUpdateWithHttpInfo(range);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /range/update [POST] This will update a specific range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Range</returns>
        public Pieces.Os.Core.Client.ApiResponse<Range> RangeUpdateWithHttpInfo(Range range = default(Range), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = range;

            localVarRequestOptions.Operation = "RangeApi.RangeUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Range>("/range/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/update [POST] This will update a specific range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Range</returns>
        public async System.Threading.Tasks.Task<Range> RangeUpdateAsync(Range range = default(Range), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Range> localVarResponse = await RangeUpdateWithHttpInfoAsync(range, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /range/update [POST] This will update a specific range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Range)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Range>> RangeUpdateWithHttpInfoAsync(Range range = default(Range), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = range;

            localVarRequestOptions.Operation = "RangeApi.RangeUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Range>("/range/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangeUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range} [GET] This will get a snapshot of a single range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Range</returns>
        public Range RangesSpecificRangeSnapshot(string range, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Range> localVarResponse = RangesSpecificRangeSnapshotWithHttpInfo(range);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /range/{range} [GET] This will get a snapshot of a single range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Range</returns>
        public Pieces.Os.Core.Client.ApiResponse<Range> RangesSpecificRangeSnapshotWithHttpInfo(string range, int operationIndex = 0)
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangesSpecificRangeSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangesSpecificRangeSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Range>("/range/{range}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangesSpecificRangeSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /range/{range} [GET] This will get a snapshot of a single range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Range</returns>
        public async System.Threading.Tasks.Task<Range> RangesSpecificRangeSnapshotAsync(string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Range> localVarResponse = await RangesSpecificRangeSnapshotWithHttpInfoAsync(range, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /range/{range} [GET] This will get a snapshot of a single range.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Range)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Range>> RangesSpecificRangeSnapshotWithHttpInfoAsync(string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling RangeApi->RangesSpecificRangeSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "RangeApi.RangesSpecificRangeSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Range>("/range/{range}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RangesSpecificRangeSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
