/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IPKCEApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /pkce/clear [POST]
        /// </summary>
        /// <remarks>
        /// This is a function to Clear a PKCE Authentication Flow
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ClearPKCE(int operationIndex = 0);

        /// <summary>
        /// /pkce/clear [POST]
        /// </summary>
        /// <remarks>
        /// This is a function to Clear a PKCE Authentication Flow
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ClearPKCEWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /pkce/code [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        PKCE GenerateCode(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0);

        /// <summary>
        /// /pkce/code [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        ApiResponse<PKCE> GenerateCodeWithHttpInfo(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0);
        /// <summary>
        /// /pkce/token [POST]
        /// </summary>
        /// <remarks>
        /// A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        PKCE GenerateToken(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0);

        /// <summary>
        /// /pkce/token [POST]
        /// </summary>
        /// <remarks>
        /// A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        ApiResponse<PKCE> GenerateTokenWithHttpInfo(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0);
        /// <summary>
        /// Your GET endpoint
        /// </summary>
        /// <remarks>
        /// An endpoint that returns a PKCE Challenge
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        PKCE GetChallenge(int operationIndex = 0);

        /// <summary>
        /// Your GET endpoint
        /// </summary>
        /// <remarks>
        /// An endpoint that returns a PKCE Challenge
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        ApiResponse<PKCE> GetChallengeWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /pkce/response/code [POST]
        /// </summary>
        /// <remarks>
        /// This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        PKCE RespondWithCode(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0);

        /// <summary>
        /// /pkce/response/code [POST]
        /// </summary>
        /// <remarks>
        /// This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        ApiResponse<PKCE> RespondWithCodeWithHttpInfo(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IPKCEApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /pkce/clear [POST]
        /// </summary>
        /// <remarks>
        /// This is a function to Clear a PKCE Authentication Flow
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ClearPKCEAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /pkce/clear [POST]
        /// </summary>
        /// <remarks>
        /// This is a function to Clear a PKCE Authentication Flow
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ClearPKCEWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /pkce/code [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        System.Threading.Tasks.Task<PKCE> GenerateCodeAsync(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /pkce/code [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        System.Threading.Tasks.Task<ApiResponse<PKCE>> GenerateCodeWithHttpInfoAsync(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /pkce/token [POST]
        /// </summary>
        /// <remarks>
        /// A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        System.Threading.Tasks.Task<PKCE> GenerateTokenAsync(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /pkce/token [POST]
        /// </summary>
        /// <remarks>
        /// A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        System.Threading.Tasks.Task<ApiResponse<PKCE>> GenerateTokenWithHttpInfoAsync(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// Your GET endpoint
        /// </summary>
        /// <remarks>
        /// An endpoint that returns a PKCE Challenge
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        System.Threading.Tasks.Task<PKCE> GetChallengeAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// Your GET endpoint
        /// </summary>
        /// <remarks>
        /// An endpoint that returns a PKCE Challenge
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        System.Threading.Tasks.Task<ApiResponse<PKCE>> GetChallengeWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /pkce/response/code [POST]
        /// </summary>
        /// <remarks>
        /// This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        System.Threading.Tasks.Task<PKCE> RespondWithCodeAsync(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /pkce/response/code [POST]
        /// </summary>
        /// <remarks>
        /// This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        System.Threading.Tasks.Task<ApiResponse<PKCE>> RespondWithCodeWithHttpInfoAsync(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IPKCEApi : IPKCEApiSync, IPKCEApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class PKCEApi : IPKCEApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="PKCEApi"/> class.
        /// </summary>
        /// <returns></returns>
        public PKCEApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PKCEApi"/> class.
        /// </summary>
        /// <returns></returns>
        public PKCEApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PKCEApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public PKCEApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PKCEApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public PKCEApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /pkce/clear [POST] This is a function to Clear a PKCE Authentication Flow
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ClearPKCE(int operationIndex = 0)
        {
            ClearPKCEWithHttpInfo();
        }

        /// <summary>
        /// /pkce/clear [POST] This is a function to Clear a PKCE Authentication Flow
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ClearPKCEWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "PKCEApi.ClearPKCE";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/pkce/clear", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ClearPKCE", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/clear [POST] This is a function to Clear a PKCE Authentication Flow
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ClearPKCEAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ClearPKCEWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /pkce/clear [POST] This is a function to Clear a PKCE Authentication Flow
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ClearPKCEWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "PKCEApi.ClearPKCE";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/pkce/clear", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ClearPKCE", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/code [POST] An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        public PKCE GenerateCode(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = GenerateCodeWithHttpInfo(seededPKCE);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/code [POST] An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        public Pieces.Os.Core.Client.ApiResponse<PKCE> GenerateCodeWithHttpInfo(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededPKCE;

            localVarRequestOptions.Operation = "PKCEApi.GenerateCode";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<PKCE>("/pkce/code", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GenerateCode", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/code [POST] An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        public async System.Threading.Tasks.Task<PKCE> GenerateCodeAsync(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = await GenerateCodeWithHttpInfoAsync(seededPKCE, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/code [POST] An endpoint to get the PKCE Code - this endpoint proxies the call out to Authorize within Auth0
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededPKCE">All of the properties that the client might want to send over to authorize a PKCE Code Flow (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<PKCE>> GenerateCodeWithHttpInfoAsync(SeededPKCE seededPKCE = default(SeededPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededPKCE;

            localVarRequestOptions.Operation = "PKCEApi.GenerateCode";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<PKCE>("/pkce/code", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GenerateCode", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/token [POST] A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        public PKCE GenerateToken(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = GenerateTokenWithHttpInfo(tokenizedPKCE);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/token [POST] A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        public Pieces.Os.Core.Client.ApiResponse<PKCE> GenerateTokenWithHttpInfo(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = tokenizedPKCE;

            localVarRequestOptions.Operation = "PKCEApi.GenerateToken";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<PKCE>("/pkce/token", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GenerateToken", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/token [POST] A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        public async System.Threading.Tasks.Task<PKCE> GenerateTokenAsync(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = await GenerateTokenWithHttpInfoAsync(tokenizedPKCE, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/token [POST] A proxy endpoint for PKCE token generation, internally calls Auth0 /oauth/token
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenizedPKCE">The needed properties to exchange a PKCE Code for an OAuth Token (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<PKCE>> GenerateTokenWithHttpInfoAsync(TokenizedPKCE tokenizedPKCE = default(TokenizedPKCE), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = tokenizedPKCE;

            localVarRequestOptions.Operation = "PKCEApi.GenerateToken";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<PKCE>("/pkce/token", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GenerateToken", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Your GET endpoint An endpoint that returns a PKCE Challenge
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        public PKCE GetChallenge(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = GetChallengeWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// Your GET endpoint An endpoint that returns a PKCE Challenge
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        public Pieces.Os.Core.Client.ApiResponse<PKCE> GetChallengeWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "PKCEApi.GetChallenge";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<PKCE>("/pkce/challenge", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GetChallenge", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Your GET endpoint An endpoint that returns a PKCE Challenge
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        public async System.Threading.Tasks.Task<PKCE> GetChallengeAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = await GetChallengeWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Your GET endpoint An endpoint that returns a PKCE Challenge
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<PKCE>> GetChallengeWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "PKCEApi.GetChallenge";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<PKCE>("/pkce/challenge", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GetChallenge", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/response/code [POST] This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>PKCE</returns>
        public PKCE RespondWithCode(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = RespondWithCodeWithHttpInfo(code, state, schema);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/response/code [POST] This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of PKCE</returns>
        public Pieces.Os.Core.Client.ApiResponse<PKCE> RespondWithCodeWithHttpInfo(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0)
        {
            // verify the required parameter 'code' is set
            if (code == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'code' when calling PKCEApi->RespondWithCode");
            }

            // verify the required parameter 'state' is set
            if (state == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'state' when calling PKCEApi->RespondWithCode");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/html"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (schema != null)
            {
                localVarRequestOptions.FormParameters.Add("schema", Pieces.Os.Core.Client.ClientUtils.Serialize(schema)); // form parameter
            }
            localVarRequestOptions.FormParameters.Add("code", Pieces.Os.Core.Client.ClientUtils.ParameterToString(code)); // form parameter
            localVarRequestOptions.FormParameters.Add("state", Pieces.Os.Core.Client.ClientUtils.ParameterToString(state)); // form parameter

            localVarRequestOptions.Operation = "PKCEApi.RespondWithCode";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<PKCE>("/pkce/response/code", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RespondWithCode", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /pkce/response/code [POST] This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of PKCE</returns>
        public async System.Threading.Tasks.Task<PKCE> RespondWithCodeAsync(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<PKCE> localVarResponse = await RespondWithCodeWithHttpInfoAsync(code, state, schema, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /pkce/response/code [POST] This is a callback function hosted to help pass along the ResultedPKCE code from authorize through to the callback.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="code">The PKCE Code to be used to access a Token.</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (PKCE)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<PKCE>> RespondWithCodeWithHttpInfoAsync(string code, string state, EmbeddedModelSchema schema = default(EmbeddedModelSchema), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'code' is set
            if (code == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'code' when calling PKCEApi->RespondWithCode");
            }

            // verify the required parameter 'state' is set
            if (state == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'state' when calling PKCEApi->RespondWithCode");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/html"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (schema != null)
            {
                localVarRequestOptions.FormParameters.Add("schema", Pieces.Os.Core.Client.ClientUtils.Serialize(schema)); // form parameter
            }
            localVarRequestOptions.FormParameters.Add("code", Pieces.Os.Core.Client.ClientUtils.ParameterToString(code)); // form parameter
            localVarRequestOptions.FormParameters.Add("state", Pieces.Os.Core.Client.ClientUtils.ParameterToString(state)); // form parameter

            localVarRequestOptions.Operation = "PKCEApi.RespondWithCode";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<PKCE>("/pkce/response/code", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("RespondWithCode", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
