/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IModelApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /model/{model}/download [POST]
        /// </summary>
        /// <remarks>
        /// Downloads a specific model to your local machine.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelSpecificModelDownload(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model}/download [POST]
        /// </summary>
        /// <remarks>
        /// Downloads a specific model to your local machine.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelSpecificModelDownloadWithHttpInfo(string model, int operationIndex = 0);
        /// <summary>
        /// /model/{model}/download/cancel [POST]
        /// </summary>
        /// <remarks>
        /// Cancels a specific model download that is currently in progress.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelSpecificModelDownloadCancel(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model}/download/cancel [POST]
        /// </summary>
        /// <remarks>
        /// Cancels a specific model download that is currently in progress.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelSpecificModelDownloadCancelWithHttpInfo(string model, int operationIndex = 0);
        /// <summary>
        /// /model/{model}/download/progress [WS]
        /// </summary>
        /// <remarks>
        /// This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ModelDownloadProgress</returns>
        ModelDownloadProgress ModelSpecificModelDownloadProgress(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model}/download/progress [WS]
        /// </summary>
        /// <remarks>
        /// This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ModelDownloadProgress</returns>
        ApiResponse<ModelDownloadProgress> ModelSpecificModelDownloadProgressWithHttpInfo(string model, int operationIndex = 0);
        /// <summary>
        /// /model/{model}/load [POST]
        /// </summary>
        /// <remarks>
        /// Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelSpecificModelLoad(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model}/load [POST]
        /// </summary>
        /// <remarks>
        /// Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelSpecificModelLoadWithHttpInfo(string model, int operationIndex = 0);
        /// <summary>
        /// /model/{model}/unload [POST]
        /// </summary>
        /// <remarks>
        /// Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelSpecificModelUnload(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model}/unload [POST]
        /// </summary>
        /// <remarks>
        /// Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelSpecificModelUnloadWithHttpInfo(string model, int operationIndex = 0);
        /// <summary>
        /// /model/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelUpdate(Model model = default(Model), int operationIndex = 0);

        /// <summary>
        /// /model/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelUpdateWithHttpInfo(Model model = default(Model), int operationIndex = 0);
        /// <summary>
        /// /model/{model} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific ML model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        Model ModelsSpecificModelSnapshot(string model, int operationIndex = 0);

        /// <summary>
        /// /model/{model} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific ML model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        ApiResponse<Model> ModelsSpecificModelSnapshotWithHttpInfo(string model, int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IModelApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /model/{model}/download [POST]
        /// </summary>
        /// <remarks>
        /// Downloads a specific model to your local machine.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelSpecificModelDownloadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model}/download [POST]
        /// </summary>
        /// <remarks>
        /// Downloads a specific model to your local machine.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelSpecificModelDownloadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/{model}/download/cancel [POST]
        /// </summary>
        /// <remarks>
        /// Cancels a specific model download that is currently in progress.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelSpecificModelDownloadCancelAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model}/download/cancel [POST]
        /// </summary>
        /// <remarks>
        /// Cancels a specific model download that is currently in progress.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelSpecificModelDownloadCancelWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/{model}/download/progress [WS]
        /// </summary>
        /// <remarks>
        /// This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ModelDownloadProgress</returns>
        System.Threading.Tasks.Task<ModelDownloadProgress> ModelSpecificModelDownloadProgressAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model}/download/progress [WS]
        /// </summary>
        /// <remarks>
        /// This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ModelDownloadProgress)</returns>
        System.Threading.Tasks.Task<ApiResponse<ModelDownloadProgress>> ModelSpecificModelDownloadProgressWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/{model}/load [POST]
        /// </summary>
        /// <remarks>
        /// Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelSpecificModelLoadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model}/load [POST]
        /// </summary>
        /// <remarks>
        /// Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelSpecificModelLoadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/{model}/unload [POST]
        /// </summary>
        /// <remarks>
        /// Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelSpecificModelUnloadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model}/unload [POST]
        /// </summary>
        /// <remarks>
        /// Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelSpecificModelUnloadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelUpdateAsync(Model model = default(Model), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelUpdateWithHttpInfoAsync(Model model = default(Model), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /model/{model} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific ML model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        System.Threading.Tasks.Task<Model> ModelsSpecificModelSnapshotAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /model/{model} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific ML model.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        System.Threading.Tasks.Task<ApiResponse<Model>> ModelsSpecificModelSnapshotWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IModelApi : IModelApiSync, IModelApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class ModelApi : IModelApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ModelApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ModelApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public ModelApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public ModelApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /model/{model}/download [POST] Downloads a specific model to your local machine.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelSpecificModelDownload(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelSpecificModelDownloadWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download [POST] Downloads a specific model to your local machine.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelSpecificModelDownloadWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownload");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownload";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Model>("/model/{model}/download", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownload", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/download [POST] Downloads a specific model to your local machine.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelSpecificModelDownloadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelSpecificModelDownloadWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download [POST] Downloads a specific model to your local machine.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelSpecificModelDownloadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownload");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownload";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Model>("/model/{model}/download", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownload", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/download/cancel [POST] Cancels a specific model download that is currently in progress.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelSpecificModelDownloadCancel(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelSpecificModelDownloadCancelWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download/cancel [POST] Cancels a specific model download that is currently in progress.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelSpecificModelDownloadCancelWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownloadCancel");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownloadCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Model>("/model/{model}/download/cancel", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownloadCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/download/cancel [POST] Cancels a specific model download that is currently in progress.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelSpecificModelDownloadCancelAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelSpecificModelDownloadCancelWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download/cancel [POST] Cancels a specific model download that is currently in progress.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelSpecificModelDownloadCancelWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownloadCancel");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownloadCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Model>("/model/{model}/download/cancel", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownloadCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/download/progress [WS] This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ModelDownloadProgress</returns>
        public ModelDownloadProgress ModelSpecificModelDownloadProgress(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ModelDownloadProgress> localVarResponse = ModelSpecificModelDownloadProgressWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download/progress [WS] This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ModelDownloadProgress</returns>
        public Pieces.Os.Core.Client.ApiResponse<ModelDownloadProgress> ModelSpecificModelDownloadProgressWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownloadProgress");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownloadProgress";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<ModelDownloadProgress>("/model/{model}/download/progress", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownloadProgress", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/download/progress [WS] This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ModelDownloadProgress</returns>
        public async System.Threading.Tasks.Task<ModelDownloadProgress> ModelSpecificModelDownloadProgressAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ModelDownloadProgress> localVarResponse = await ModelSpecificModelDownloadProgressWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/download/progress [WS] This is a WebSocket connection that provides real-time updates on the download progress of a specific model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ModelDownloadProgress)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ModelDownloadProgress>> ModelSpecificModelDownloadProgressWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelDownloadProgress");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelDownloadProgress";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<ModelDownloadProgress>("/model/{model}/download/progress", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelDownloadProgress", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/load [POST] Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelSpecificModelLoad(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelSpecificModelLoadWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/load [POST] Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelSpecificModelLoadWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelLoad");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelLoad";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Model>("/model/{model}/load", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelLoad", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/load [POST] Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelSpecificModelLoadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelSpecificModelLoadWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/load [POST] Loads a previously downloaded model into memory. It differs from downloading, as downloading involves transferring the entire model to your machine, while loading simply loads the model into memory.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelSpecificModelLoadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelLoad");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelLoad";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Model>("/model/{model}/load", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelLoad", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/unload [POST] Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelSpecificModelUnload(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelSpecificModelUnloadWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/unload [POST] Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelSpecificModelUnloadWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelUnload");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelUnload";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Model>("/model/{model}/unload", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelUnload", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model}/unload [POST] Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelSpecificModelUnloadAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelSpecificModelUnloadWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model}/unload [POST] Unloads a previously loaded model from memory and effectively frees up the RAM consumed by the model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelSpecificModelUnloadWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelSpecificModelUnload");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelSpecificModelUnload";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Model>("/model/{model}/unload", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelSpecificModelUnload", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/update [POST] Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelUpdate(Model model = default(Model), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelUpdateWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/update [POST] Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelUpdateWithHttpInfo(Model model = default(Model), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = model;

            localVarRequestOptions.Operation = "ModelApi.ModelUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Model>("/model/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/update [POST] Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelUpdateAsync(Model model = default(Model), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelUpdateWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/update [POST] Updates a machine learning model. This functionality is exclusively available for models with the &#39;custom:true&#39; setting.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelUpdateWithHttpInfoAsync(Model model = default(Model), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = model;

            localVarRequestOptions.Operation = "ModelApi.ModelUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Model>("/model/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model} [GET] Retrieves a specific ML model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Model</returns>
        public Model ModelsSpecificModelSnapshot(string model, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = ModelsSpecificModelSnapshotWithHttpInfo(model);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model} [GET] Retrieves a specific ML model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Model</returns>
        public Pieces.Os.Core.Client.ApiResponse<Model> ModelsSpecificModelSnapshotWithHttpInfo(string model, int operationIndex = 0)
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelsSpecificModelSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelsSpecificModelSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Model>("/model/{model}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelsSpecificModelSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /model/{model} [GET] Retrieves a specific ML model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Model</returns>
        public async System.Threading.Tasks.Task<Model> ModelsSpecificModelSnapshotAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Model> localVarResponse = await ModelsSpecificModelSnapshotWithHttpInfoAsync(model, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /model/{model} [GET] Retrieves a specific ML model.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="model">model id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Model)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Model>> ModelsSpecificModelSnapshotWithHttpInfoAsync(string model, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'model' is set
            if (model == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'model' when calling ModelApi->ModelsSpecificModelSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("model", Pieces.Os.Core.Client.ClientUtils.ParameterToString(model)); // path parameter

            localVarRequestOptions.Operation = "ModelApi.ModelsSpecificModelSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Model>("/model/{model}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ModelsSpecificModelSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
