/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IMachineLearningApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET]
        /// </summary>
        /// <remarks>
        /// This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>OnboardedPersonaDetails</returns>
        OnboardedPersonaDetails PersonificationTechnicalLanguageGeneration(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0);

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET]
        /// </summary>
        /// <remarks>
        /// This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of OnboardedPersonaDetails</returns>
        ApiResponse<OnboardedPersonaDetails> PersonificationTechnicalLanguageGenerationWithHttpInfo(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0);
        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST]
        /// </summary>
        /// <remarks>
        /// This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SegmentedTechnicalLanguage</returns>
        SegmentedTechnicalLanguage SegmentTechnicalLanguage(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0);

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST]
        /// </summary>
        /// <remarks>
        /// This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SegmentedTechnicalLanguage</returns>
        ApiResponse<SegmentedTechnicalLanguage> SegmentTechnicalLanguageWithHttpInfo(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IMachineLearningApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET]
        /// </summary>
        /// <remarks>
        /// This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of OnboardedPersonaDetails</returns>
        System.Threading.Tasks.Task<OnboardedPersonaDetails> PersonificationTechnicalLanguageGenerationAsync(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET]
        /// </summary>
        /// <remarks>
        /// This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (OnboardedPersonaDetails)</returns>
        System.Threading.Tasks.Task<ApiResponse<OnboardedPersonaDetails>> PersonificationTechnicalLanguageGenerationWithHttpInfoAsync(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST]
        /// </summary>
        /// <remarks>
        /// This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SegmentedTechnicalLanguage</returns>
        System.Threading.Tasks.Task<SegmentedTechnicalLanguage> SegmentTechnicalLanguageAsync(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST]
        /// </summary>
        /// <remarks>
        /// This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SegmentedTechnicalLanguage)</returns>
        System.Threading.Tasks.Task<ApiResponse<SegmentedTechnicalLanguage>> SegmentTechnicalLanguageWithHttpInfoAsync(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IMachineLearningApi : IMachineLearningApiSync, IMachineLearningApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class MachineLearningApi : IMachineLearningApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="MachineLearningApi"/> class.
        /// </summary>
        /// <returns></returns>
        public MachineLearningApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="MachineLearningApi"/> class.
        /// </summary>
        /// <returns></returns>
        public MachineLearningApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="MachineLearningApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public MachineLearningApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="MachineLearningApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public MachineLearningApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET] This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>OnboardedPersonaDetails</returns>
        public OnboardedPersonaDetails PersonificationTechnicalLanguageGeneration(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<OnboardedPersonaDetails> localVarResponse = PersonificationTechnicalLanguageGenerationWithHttpInfo(preonboardedPersonaDetails);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET] This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of OnboardedPersonaDetails</returns>
        public Pieces.Os.Core.Client.ApiResponse<OnboardedPersonaDetails> PersonificationTechnicalLanguageGenerationWithHttpInfo(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = preonboardedPersonaDetails;

            localVarRequestOptions.Operation = "MachineLearningApi.PersonificationTechnicalLanguageGeneration";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<OnboardedPersonaDetails>("/machine_learning/text/technical_language/generators/personification", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("PersonificationTechnicalLanguageGeneration", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET] This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of OnboardedPersonaDetails</returns>
        public async System.Threading.Tasks.Task<OnboardedPersonaDetails> PersonificationTechnicalLanguageGenerationAsync(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<OnboardedPersonaDetails> localVarResponse = await PersonificationTechnicalLanguageGenerationWithHttpInfoAsync(preonboardedPersonaDetails, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/generators/personification [GET] This is going to take in some personification details ie languages &amp; personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preonboardedPersonaDetails"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (OnboardedPersonaDetails)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<OnboardedPersonaDetails>> PersonificationTechnicalLanguageGenerationWithHttpInfoAsync(PreonboardedPersonaDetails preonboardedPersonaDetails = default(PreonboardedPersonaDetails), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = preonboardedPersonaDetails;

            localVarRequestOptions.Operation = "MachineLearningApi.PersonificationTechnicalLanguageGeneration";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<OnboardedPersonaDetails>("/machine_learning/text/technical_language/generators/personification", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("PersonificationTechnicalLanguageGeneration", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST] This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SegmentedTechnicalLanguage</returns>
        public SegmentedTechnicalLanguage SegmentTechnicalLanguage(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<SegmentedTechnicalLanguage> localVarResponse = SegmentTechnicalLanguageWithHttpInfo(classify, unsegmentedTechnicalLanguage);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST] This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SegmentedTechnicalLanguage</returns>
        public Pieces.Os.Core.Client.ApiResponse<SegmentedTechnicalLanguage> SegmentTechnicalLanguageWithHttpInfo(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (classify != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "classify", classify));
            }
            localVarRequestOptions.Data = unsegmentedTechnicalLanguage;

            localVarRequestOptions.Operation = "MachineLearningApi.SegmentTechnicalLanguage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<SegmentedTechnicalLanguage>("/machine_learning/text/technical_language/parsers/segmentation", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SegmentTechnicalLanguage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST] This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SegmentedTechnicalLanguage</returns>
        public async System.Threading.Tasks.Task<SegmentedTechnicalLanguage> SegmentTechnicalLanguageAsync(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<SegmentedTechnicalLanguage> localVarResponse = await SegmentTechnicalLanguageWithHttpInfoAsync(classify, unsegmentedTechnicalLanguage, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /machine_learning/text/technical_language/parsers/segmentation [POST] This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along &#39;classify&#39; then we will optionally classify the just the code that is segmented.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="classify">This will let us know if you want us to classifiy your code, this is default to false. (optional)</param>
        /// <param name="unsegmentedTechnicalLanguage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SegmentedTechnicalLanguage)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<SegmentedTechnicalLanguage>> SegmentTechnicalLanguageWithHttpInfoAsync(bool? classify = default(bool?), UnsegmentedTechnicalLanguage unsegmentedTechnicalLanguage = default(UnsegmentedTechnicalLanguage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (classify != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "classify", classify));
            }
            localVarRequestOptions.Data = unsegmentedTechnicalLanguage;

            localVarRequestOptions.Operation = "MachineLearningApi.SegmentTechnicalLanguage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<SegmentedTechnicalLanguage>("/machine_learning/text/technical_language/parsers/segmentation", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SegmentTechnicalLanguage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
