/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHintApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void HintAssociateAsset(string hint, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> HintAssociateAssetWithHttpInfo(string hint, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void HintDisassociateAsset(string hint, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> HintDisassociateAssetWithHttpInfo(string hint, Guid asset, int operationIndex = 0);
        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void HintScoresIncrement(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> HintScoresIncrementWithHttpInfo(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /hint/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Hint</returns>
        Hint HintSpecificHintSnapshot(string hint, int operationIndex = 0);

        /// <summary>
        /// /hint/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Hint</returns>
        ApiResponse<Hint> HintSpecificHintSnapshotWithHttpInfo(string hint, int operationIndex = 0);
        /// <summary>
        /// /hint/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Hint</returns>
        Hint HintUpdate(Hint hint = default(Hint), int operationIndex = 0);

        /// <summary>
        /// /hint/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Hint</returns>
        ApiResponse<Hint> HintUpdateWithHttpInfo(Hint hint = default(Hint), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHintApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task HintAssociateAssetAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> HintAssociateAssetWithHttpInfoAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task HintDisassociateAssetAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> HintDisassociateAssetWithHttpInfoAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task HintScoresIncrementAsync(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> HintScoresIncrementWithHttpInfoAsync(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /hint/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Hint</returns>
        System.Threading.Tasks.Task<Hint> HintSpecificHintSnapshotAsync(string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /hint/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Hint)</returns>
        System.Threading.Tasks.Task<ApiResponse<Hint>> HintSpecificHintSnapshotWithHttpInfoAsync(string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /hint/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Hint</returns>
        System.Threading.Tasks.Task<Hint> HintUpdateAsync(Hint hint = default(Hint), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /hint/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific hint.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Hint)</returns>
        System.Threading.Tasks.Task<ApiResponse<Hint>> HintUpdateWithHttpInfoAsync(Hint hint = default(Hint), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHintApi : IHintApiSync, IHintApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class HintApi : IHintApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="HintApi"/> class.
        /// </summary>
        /// <returns></returns>
        public HintApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HintApi"/> class.
        /// </summary>
        /// <returns></returns>
        public HintApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HintApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public HintApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HintApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public HintApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST] associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void HintAssociateAsset(string hint, Guid asset, int operationIndex = 0)
        {
            HintAssociateAssetWithHttpInfo(hint, asset);
        }

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST] associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> HintAssociateAssetWithHttpInfo(string hint, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintAssociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/hint/{hint}/assets/associate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST] associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task HintAssociateAssetAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await HintAssociateAssetWithHttpInfoAsync(hint, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /hint/{hint}/assets/associate/{asset} [POST] associates a hint and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> HintAssociateAssetWithHttpInfoAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintAssociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/hint/{hint}/assets/associate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST] Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void HintDisassociateAsset(string hint, Guid asset, int operationIndex = 0)
        {
            HintDisassociateAssetWithHttpInfo(hint, asset);
        }

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST] Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> HintDisassociateAssetWithHttpInfo(string hint, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintDisassociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/hint/{hint}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST] Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task HintDisassociateAssetAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await HintDisassociateAssetWithHttpInfoAsync(hint, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /hint/{hint}/assets/disassociate/{asset} [POST] Disassociates a hint from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> HintDisassociateAssetWithHttpInfoAsync(string hint, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintDisassociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/hint/{hint}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void HintScoresIncrement(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            HintScoresIncrementWithHttpInfo(hint, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> HintScoresIncrementWithHttpInfo(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "HintApi.HintScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/hint/{hint}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task HintScoresIncrementAsync(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await HintScoresIncrementWithHttpInfoAsync(hint, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/hint/{hint}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> HintScoresIncrementWithHttpInfoAsync(string hint, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "HintApi.HintScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/hint/{hint}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/{hint} [POST] This will get a snapshot of a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Hint</returns>
        public Hint HintSpecificHintSnapshot(string hint, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Hint> localVarResponse = HintSpecificHintSnapshotWithHttpInfo(hint);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /hint/{hint} [POST] This will get a snapshot of a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Hint</returns>
        public Pieces.Os.Core.Client.ApiResponse<Hint> HintSpecificHintSnapshotWithHttpInfo(string hint, int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintSpecificHintSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintSpecificHintSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Hint>("/hint/{hint}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintSpecificHintSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/{hint} [POST] This will get a snapshot of a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Hint</returns>
        public async System.Threading.Tasks.Task<Hint> HintSpecificHintSnapshotAsync(string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Hint> localVarResponse = await HintSpecificHintSnapshotWithHttpInfoAsync(hint, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /hint/{hint} [POST] This will get a snapshot of a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Hint)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Hint>> HintSpecificHintSnapshotWithHttpInfoAsync(string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling HintApi->HintSpecificHintSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "HintApi.HintSpecificHintSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Hint>("/hint/{hint}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintSpecificHintSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/update [POST] This will update a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Hint</returns>
        public Hint HintUpdate(Hint hint = default(Hint), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Hint> localVarResponse = HintUpdateWithHttpInfo(hint);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /hint/update [POST] This will update a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Hint</returns>
        public Pieces.Os.Core.Client.ApiResponse<Hint> HintUpdateWithHttpInfo(Hint hint = default(Hint), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = hint;

            localVarRequestOptions.Operation = "HintApi.HintUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Hint>("/hint/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /hint/update [POST] This will update a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Hint</returns>
        public async System.Threading.Tasks.Task<Hint> HintUpdateAsync(Hint hint = default(Hint), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Hint> localVarResponse = await HintUpdateWithHttpInfoAsync(hint, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /hint/update [POST] This will update a specific hint.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="hint"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Hint)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Hint>> HintUpdateWithHttpInfoAsync(Hint hint = default(Hint), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = hint;

            localVarRequestOptions.Operation = "HintApi.HintUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Hint>("/hint/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("HintUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
