/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormatApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /format/{format}/analysis [GET]
        /// </summary>
        /// <remarks>
        /// This will get an analysis from a format&#39;s id.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Analysis</returns>
        Analysis FormatAnalysis(Guid format, int operationIndex = 0);

        /// <summary>
        /// /format/{format}/analysis [GET]
        /// </summary>
        /// <remarks>
        /// This will get an analysis from a format&#39;s id.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Analysis</returns>
        ApiResponse<Analysis> FormatAnalysisWithHttpInfo(Guid format, int operationIndex = 0);
        /// <summary>
        /// /format/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will be used to reclassify a single Format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        Format FormatReclassify(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0);

        /// <summary>
        /// /format/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will be used to reclassify a single Format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        ApiResponse<Format> FormatReclassifyWithHttpInfo(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0);
        /// <summary>
        /// /format/{format} [GET] Scoped to Format
        /// </summary>
        /// <remarks>
        /// Get a snapshot of a specific format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        Format FormatSnapshot(Guid format, bool? transferable = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /format/{format} [GET] Scoped to Format
        /// </summary>
        /// <remarks>
        /// Get a snapshot of a specific format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        ApiResponse<Format> FormatSnapshotWithHttpInfo(Guid format, bool? transferable = default(bool?), int operationIndex = 0);
        /// <summary>
        /// [POST] /format/update/value
        /// </summary>
        /// <remarks>
        /// This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        Format FormatUpdateValue(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0);

        /// <summary>
        /// [POST] /format/update/value
        /// </summary>
        /// <remarks>
        /// This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        ApiResponse<Format> FormatUpdateValueWithHttpInfo(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormatApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /format/{format}/analysis [GET]
        /// </summary>
        /// <remarks>
        /// This will get an analysis from a format&#39;s id.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Analysis</returns>
        System.Threading.Tasks.Task<Analysis> FormatAnalysisAsync(Guid format, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /format/{format}/analysis [GET]
        /// </summary>
        /// <remarks>
        /// This will get an analysis from a format&#39;s id.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Analysis)</returns>
        System.Threading.Tasks.Task<ApiResponse<Analysis>> FormatAnalysisWithHttpInfoAsync(Guid format, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /format/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will be used to reclassify a single Format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        System.Threading.Tasks.Task<Format> FormatReclassifyAsync(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /format/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will be used to reclassify a single Format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        System.Threading.Tasks.Task<ApiResponse<Format>> FormatReclassifyWithHttpInfoAsync(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /format/{format} [GET] Scoped to Format
        /// </summary>
        /// <remarks>
        /// Get a snapshot of a specific format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        System.Threading.Tasks.Task<Format> FormatSnapshotAsync(Guid format, bool? transferable = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /format/{format} [GET] Scoped to Format
        /// </summary>
        /// <remarks>
        /// Get a snapshot of a specific format.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        System.Threading.Tasks.Task<ApiResponse<Format>> FormatSnapshotWithHttpInfoAsync(Guid format, bool? transferable = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// [POST] /format/update/value
        /// </summary>
        /// <remarks>
        /// This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        System.Threading.Tasks.Task<Format> FormatUpdateValueAsync(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// [POST] /format/update/value
        /// </summary>
        /// <remarks>
        /// This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        System.Threading.Tasks.Task<ApiResponse<Format>> FormatUpdateValueWithHttpInfoAsync(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormatApi : IFormatApiSync, IFormatApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class FormatApi : IFormatApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="FormatApi"/> class.
        /// </summary>
        /// <returns></returns>
        public FormatApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormatApi"/> class.
        /// </summary>
        /// <returns></returns>
        public FormatApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormatApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public FormatApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormatApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public FormatApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /format/{format}/analysis [GET] This will get an analysis from a format&#39;s id.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Analysis</returns>
        public Analysis FormatAnalysis(Guid format, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Analysis> localVarResponse = FormatAnalysisWithHttpInfo(format);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/{format}/analysis [GET] This will get an analysis from a format&#39;s id.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Analysis</returns>
        public Pieces.Os.Core.Client.ApiResponse<Analysis> FormatAnalysisWithHttpInfo(Guid format, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("format", Pieces.Os.Core.Client.ClientUtils.ParameterToString(format)); // path parameter

            localVarRequestOptions.Operation = "FormatApi.FormatAnalysis";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Analysis>("/format/{format}/analysis", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatAnalysis", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /format/{format}/analysis [GET] This will get an analysis from a format&#39;s id.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Analysis</returns>
        public async System.Threading.Tasks.Task<Analysis> FormatAnalysisAsync(Guid format, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Analysis> localVarResponse = await FormatAnalysisWithHttpInfoAsync(format, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/{format}/analysis [GET] This will get an analysis from a format&#39;s id.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Analysis)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Analysis>> FormatAnalysisWithHttpInfoAsync(Guid format, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("format", Pieces.Os.Core.Client.ClientUtils.ParameterToString(format)); // path parameter

            localVarRequestOptions.Operation = "FormatApi.FormatAnalysis";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Analysis>("/format/{format}/analysis", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatAnalysis", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /format/reclassify [POST] This endpoint will be used to reclassify a single Format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        public Format FormatReclassify(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = FormatReclassifyWithHttpInfo(transferable, formatReclassification);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/reclassify [POST] This endpoint will be used to reclassify a single Format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        public Pieces.Os.Core.Client.ApiResponse<Format> FormatReclassifyWithHttpInfo(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }
            localVarRequestOptions.Data = formatReclassification;

            localVarRequestOptions.Operation = "FormatApi.FormatReclassify";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Format>("/format/reclassify", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatReclassify", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /format/reclassify [POST] This endpoint will be used to reclassify a single Format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        public async System.Threading.Tasks.Task<Format> FormatReclassifyAsync(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = await FormatReclassifyWithHttpInfoAsync(transferable, formatReclassification, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/reclassify [POST] This endpoint will be used to reclassify a single Format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="formatReclassification"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Format>> FormatReclassifyWithHttpInfoAsync(bool? transferable = default(bool?), FormatReclassification formatReclassification = default(FormatReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }
            localVarRequestOptions.Data = formatReclassification;

            localVarRequestOptions.Operation = "FormatApi.FormatReclassify";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Format>("/format/reclassify", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatReclassify", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /format/{format} [GET] Scoped to Format Get a snapshot of a specific format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        public Format FormatSnapshot(Guid format, bool? transferable = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = FormatSnapshotWithHttpInfo(format, transferable);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/{format} [GET] Scoped to Format Get a snapshot of a specific format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        public Pieces.Os.Core.Client.ApiResponse<Format> FormatSnapshotWithHttpInfo(Guid format, bool? transferable = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("format", Pieces.Os.Core.Client.ClientUtils.ParameterToString(format)); // path parameter
            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }

            localVarRequestOptions.Operation = "FormatApi.FormatSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Format>("/format/{format}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /format/{format} [GET] Scoped to Format Get a snapshot of a specific format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        public async System.Threading.Tasks.Task<Format> FormatSnapshotAsync(Guid format, bool? transferable = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = await FormatSnapshotWithHttpInfoAsync(format, transferable, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /format/{format} [GET] Scoped to Format Get a snapshot of a specific format.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="format">The id (uuid) for a specific format.</param>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Format>> FormatSnapshotWithHttpInfoAsync(Guid format, bool? transferable = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("format", Pieces.Os.Core.Client.ClientUtils.ParameterToString(format)); // path parameter
            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }

            localVarRequestOptions.Operation = "FormatApi.FormatSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Format>("/format/{format}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// [POST] /format/update/value This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Format</returns>
        public Format FormatUpdateValue(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = FormatUpdateValueWithHttpInfo(transferable, format);
            return localVarResponse.Data;
        }

        /// <summary>
        /// [POST] /format/update/value This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Format</returns>
        public Pieces.Os.Core.Client.ApiResponse<Format> FormatUpdateValueWithHttpInfo(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }
            localVarRequestOptions.Data = format;

            localVarRequestOptions.Operation = "FormatApi.FormatUpdateValue";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Format>("/format/update/value", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatUpdateValue", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// [POST] /format/update/value This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Format</returns>
        public async System.Threading.Tasks.Task<Format> FormatUpdateValueAsync(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Format> localVarResponse = await FormatUpdateValueWithHttpInfoAsync(transferable, format, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// [POST] /format/update/value This will update a format&#39;s value, ie, a formats fragment or file depending on what is provided.  code/text fragment behavior: If this format is an asset.preview.base we will update the asset.original&#39;s value. if this format is an asset.preview.original we will update the asset.preview.base&#39;s value.  code/text file behavior: If the the format that is update is the asset.preview.base is a fragment and the asset.original is file then we will update the asset.original&#39;s value to be bytes or string respectively. This goes the same for orignal to preview but will be go the reverse order so if the original is a file we will update the preview base&#39;s fragment string.  image fragment/file: We will not modify preview -&gt; orignal or original -&gt; preview here. so there are zero side effects in this case, and will update as normal. (this will be the case for all other value updates.)
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferable">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="format">This is the format that you want to update. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Format)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Format>> FormatUpdateValueWithHttpInfoAsync(bool? transferable = default(bool?), Format format = default(Format), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferable != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferable", transferable));
            }
            localVarRequestOptions.Data = format;

            localVarRequestOptions.Operation = "FormatApi.FormatUpdateValue";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Format>("/format/update/value", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("FormatUpdateValue", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
