/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IExternalProviderApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /external_provider/api_key/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>CreatedExternalProviderApiKey</returns>
        CreatedExternalProviderApiKey ExternalProviderApiKeyCreate(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0);

        /// <summary>
        /// /external_provider/api_key/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of CreatedExternalProviderApiKey</returns>
        ApiResponse<CreatedExternalProviderApiKey> ExternalProviderApiKeyCreateWithHttpInfo(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0);
        /// <summary>
        /// /external_provider/api_key/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DeletedExternalProviderApiKey</returns>
        DeletedExternalProviderApiKey ExternalProviderApiKeyDelete(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0);

        /// <summary>
        /// /external_provider/api_key/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DeletedExternalProviderApiKey</returns>
        ApiResponse<DeletedExternalProviderApiKey> ExternalProviderApiKeyDeleteWithHttpInfo(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0);
        /// <summary>
        /// /external_provider/api_key/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>UpdatedExternalProviderApiKey</returns>
        UpdatedExternalProviderApiKey ExternalProviderApiKeyUpdate(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0);

        /// <summary>
        /// /external_provider/api_key/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of UpdatedExternalProviderApiKey</returns>
        ApiResponse<UpdatedExternalProviderApiKey> ExternalProviderApiKeyUpdateWithHttpInfo(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IExternalProviderApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /external_provider/api_key/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of CreatedExternalProviderApiKey</returns>
        System.Threading.Tasks.Task<CreatedExternalProviderApiKey> ExternalProviderApiKeyCreateAsync(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /external_provider/api_key/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (CreatedExternalProviderApiKey)</returns>
        System.Threading.Tasks.Task<ApiResponse<CreatedExternalProviderApiKey>> ExternalProviderApiKeyCreateWithHttpInfoAsync(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /external_provider/api_key/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DeletedExternalProviderApiKey</returns>
        System.Threading.Tasks.Task<DeletedExternalProviderApiKey> ExternalProviderApiKeyDeleteAsync(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /external_provider/api_key/delete [POST]
        /// </summary>
        /// <remarks>
        /// This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DeletedExternalProviderApiKey)</returns>
        System.Threading.Tasks.Task<ApiResponse<DeletedExternalProviderApiKey>> ExternalProviderApiKeyDeleteWithHttpInfoAsync(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /external_provider/api_key/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of UpdatedExternalProviderApiKey</returns>
        System.Threading.Tasks.Task<UpdatedExternalProviderApiKey> ExternalProviderApiKeyUpdateAsync(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /external_provider/api_key/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (UpdatedExternalProviderApiKey)</returns>
        System.Threading.Tasks.Task<ApiResponse<UpdatedExternalProviderApiKey>> ExternalProviderApiKeyUpdateWithHttpInfoAsync(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IExternalProviderApi : IExternalProviderApiSync, IExternalProviderApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class ExternalProviderApi : IExternalProviderApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProviderApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ExternalProviderApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProviderApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ExternalProviderApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProviderApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public ExternalProviderApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ExternalProviderApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public ExternalProviderApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /external_provider/api_key/create [POST] This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>CreatedExternalProviderApiKey</returns>
        public CreatedExternalProviderApiKey ExternalProviderApiKeyCreate(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<CreatedExternalProviderApiKey> localVarResponse = ExternalProviderApiKeyCreateWithHttpInfo(precreatedExternalProviderApiKey);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/create [POST] This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of CreatedExternalProviderApiKey</returns>
        public Pieces.Os.Core.Client.ApiResponse<CreatedExternalProviderApiKey> ExternalProviderApiKeyCreateWithHttpInfo(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = precreatedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyCreate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<CreatedExternalProviderApiKey>("/external_provider/api_key/create", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyCreate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /external_provider/api_key/create [POST] This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of CreatedExternalProviderApiKey</returns>
        public async System.Threading.Tasks.Task<CreatedExternalProviderApiKey> ExternalProviderApiKeyCreateAsync(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<CreatedExternalProviderApiKey> localVarResponse = await ExternalProviderApiKeyCreateWithHttpInfoAsync(precreatedExternalProviderApiKey, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/create [POST] This will create a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="precreatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (CreatedExternalProviderApiKey)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<CreatedExternalProviderApiKey>> ExternalProviderApiKeyCreateWithHttpInfoAsync(PrecreatedExternalProviderApiKey precreatedExternalProviderApiKey = default(PrecreatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = precreatedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyCreate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<CreatedExternalProviderApiKey>("/external_provider/api_key/create", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyCreate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /external_provider/api_key/delete [POST] This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DeletedExternalProviderApiKey</returns>
        public DeletedExternalProviderApiKey ExternalProviderApiKeyDelete(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<DeletedExternalProviderApiKey> localVarResponse = ExternalProviderApiKeyDeleteWithHttpInfo(predeletedExternalProviderApiKey);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/delete [POST] This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DeletedExternalProviderApiKey</returns>
        public Pieces.Os.Core.Client.ApiResponse<DeletedExternalProviderApiKey> ExternalProviderApiKeyDeleteWithHttpInfo(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = predeletedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyDelete";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<DeletedExternalProviderApiKey>("/external_provider/api_key/delete", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyDelete", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /external_provider/api_key/delete [POST] This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DeletedExternalProviderApiKey</returns>
        public async System.Threading.Tasks.Task<DeletedExternalProviderApiKey> ExternalProviderApiKeyDeleteAsync(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<DeletedExternalProviderApiKey> localVarResponse = await ExternalProviderApiKeyDeleteWithHttpInfoAsync(predeletedExternalProviderApiKey, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/delete [POST] This will remove a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="predeletedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DeletedExternalProviderApiKey)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<DeletedExternalProviderApiKey>> ExternalProviderApiKeyDeleteWithHttpInfoAsync(PredeletedExternalProviderApiKey predeletedExternalProviderApiKey = default(PredeletedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = predeletedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyDelete";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<DeletedExternalProviderApiKey>("/external_provider/api_key/delete", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyDelete", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /external_provider/api_key/update [POST] This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>UpdatedExternalProviderApiKey</returns>
        public UpdatedExternalProviderApiKey ExternalProviderApiKeyUpdate(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<UpdatedExternalProviderApiKey> localVarResponse = ExternalProviderApiKeyUpdateWithHttpInfo(preupdatedExternalProviderApiKey);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/update [POST] This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of UpdatedExternalProviderApiKey</returns>
        public Pieces.Os.Core.Client.ApiResponse<UpdatedExternalProviderApiKey> ExternalProviderApiKeyUpdateWithHttpInfo(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = preupdatedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<UpdatedExternalProviderApiKey>("/external_provider/api_key/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /external_provider/api_key/update [POST] This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of UpdatedExternalProviderApiKey</returns>
        public async System.Threading.Tasks.Task<UpdatedExternalProviderApiKey> ExternalProviderApiKeyUpdateAsync(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<UpdatedExternalProviderApiKey> localVarResponse = await ExternalProviderApiKeyUpdateWithHttpInfoAsync(preupdatedExternalProviderApiKey, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /external_provider/api_key/update [POST] This will update a specific external_provider api_key from a specific user Auth0UserMetadata
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="preupdatedExternalProviderApiKey"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (UpdatedExternalProviderApiKey)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<UpdatedExternalProviderApiKey>> ExternalProviderApiKeyUpdateWithHttpInfoAsync(PreupdatedExternalProviderApiKey preupdatedExternalProviderApiKey = default(PreupdatedExternalProviderApiKey), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = preupdatedExternalProviderApiKey;

            localVarRequestOptions.Operation = "ExternalProviderApi.ExternalProviderApiKeyUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<UpdatedExternalProviderApiKey>("/external_provider/api_key/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExternalProviderApiKeyUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
