/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IDiscoveryApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /discovery/discover/assets [POST]
        /// </summary>
        /// <remarks>
        /// This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredAssets</returns>
        DiscoveredAssets DiscoveryDiscoverAssets(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0);

        /// <summary>
        /// /discovery/discover/assets [POST]
        /// </summary>
        /// <remarks>
        /// This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredAssets</returns>
        ApiResponse<DiscoveredAssets> DiscoveryDiscoverAssetsWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0);
        /// <summary>
        /// /discovery/discover/assets/html[POST]
        /// </summary>
        /// <remarks>
        /// This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredHtmlWebpages</returns>
        DiscoveredHtmlWebpages DiscoveryDiscoverAssetsHtml(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0);

        /// <summary>
        /// /discovery/discover/assets/html[POST]
        /// </summary>
        /// <remarks>
        /// This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredHtmlWebpages</returns>
        ApiResponse<DiscoveredHtmlWebpages> DiscoveryDiscoverAssetsHtmlWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0);
        /// <summary>
        /// /discovery/discover/sensitives [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredSensitives</returns>
        DiscoveredSensitives DiscoveryDiscoverSensitives(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0);

        /// <summary>
        /// /discovery/discover/sensitives [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredSensitives</returns>
        ApiResponse<DiscoveredSensitives> DiscoveryDiscoverSensitivesWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0);
        /// <summary>
        /// /discovery/discover/tags/related [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredRelatedTags</returns>
        DiscoveredRelatedTags DiscoveryDiscoverTagsRelated(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0);

        /// <summary>
        /// /discovery/discover/tags/related [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredRelatedTags</returns>
        ApiResponse<DiscoveredRelatedTags> DiscoveryDiscoverTagsRelatedWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IDiscoveryApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /discovery/discover/assets [POST]
        /// </summary>
        /// <remarks>
        /// This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredAssets</returns>
        System.Threading.Tasks.Task<DiscoveredAssets> DiscoveryDiscoverAssetsAsync(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /discovery/discover/assets [POST]
        /// </summary>
        /// <remarks>
        /// This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredAssets)</returns>
        System.Threading.Tasks.Task<ApiResponse<DiscoveredAssets>> DiscoveryDiscoverAssetsWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /discovery/discover/assets/html[POST]
        /// </summary>
        /// <remarks>
        /// This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredHtmlWebpages</returns>
        System.Threading.Tasks.Task<DiscoveredHtmlWebpages> DiscoveryDiscoverAssetsHtmlAsync(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /discovery/discover/assets/html[POST]
        /// </summary>
        /// <remarks>
        /// This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredHtmlWebpages)</returns>
        System.Threading.Tasks.Task<ApiResponse<DiscoveredHtmlWebpages>> DiscoveryDiscoverAssetsHtmlWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /discovery/discover/sensitives [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredSensitives</returns>
        System.Threading.Tasks.Task<DiscoveredSensitives> DiscoveryDiscoverSensitivesAsync(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /discovery/discover/sensitives [POST]
        /// </summary>
        /// <remarks>
        /// This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredSensitives)</returns>
        System.Threading.Tasks.Task<ApiResponse<DiscoveredSensitives>> DiscoveryDiscoverSensitivesWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /discovery/discover/tags/related [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredRelatedTags</returns>
        System.Threading.Tasks.Task<DiscoveredRelatedTags> DiscoveryDiscoverTagsRelatedAsync(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /discovery/discover/tags/related [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredRelatedTags)</returns>
        System.Threading.Tasks.Task<ApiResponse<DiscoveredRelatedTags>> DiscoveryDiscoverTagsRelatedWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IDiscoveryApi : IDiscoveryApiSync, IDiscoveryApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class DiscoveryApi : IDiscoveryApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveryApi"/> class.
        /// </summary>
        /// <returns></returns>
        public DiscoveryApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveryApi"/> class.
        /// </summary>
        /// <returns></returns>
        public DiscoveryApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveryApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public DiscoveryApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DiscoveryApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public DiscoveryApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /discovery/discover/assets [POST] This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredAssets</returns>
        public DiscoveredAssets DiscoveryDiscoverAssets(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredAssets> localVarResponse = DiscoveryDiscoverAssetsWithHttpInfo(automatic, seededDiscoverableAssets);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/assets [POST] This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredAssets</returns>
        public Pieces.Os.Core.Client.ApiResponse<DiscoveredAssets> DiscoveryDiscoverAssetsWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableAssets;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverAssets";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<DiscoveredAssets>("/discovery/discover/assets", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverAssets", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/assets [POST] This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredAssets</returns>
        public async System.Threading.Tasks.Task<DiscoveredAssets> DiscoveryDiscoverAssetsAsync(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredAssets> localVarResponse = await DiscoveryDiscoverAssetsWithHttpInfoAsync(automatic, seededDiscoverableAssets, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/assets [POST] This is the endpoint used for bulk import. In both cases of the bulk import flow, fragments or files. When we already have \&quot;snippets\&quot; or fragments to discover and now our job is to check if they are actually valid snippets(clustering). Otherwise, we should have a file to parse &amp;&amp; snippitize and then run through the clustering.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableAssets">The discovery/discover/assets endpoint will accept seededDiscoverableAssets, that represetns an iterable of multiple fragments or files. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredAssets)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<DiscoveredAssets>> DiscoveryDiscoverAssetsWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableAssets seededDiscoverableAssets = default(SeededDiscoverableAssets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableAssets;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverAssets";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<DiscoveredAssets>("/discovery/discover/assets", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverAssets", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/assets/html[POST] This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredHtmlWebpages</returns>
        public DiscoveredHtmlWebpages DiscoveryDiscoverAssetsHtml(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredHtmlWebpages> localVarResponse = DiscoveryDiscoverAssetsHtmlWithHttpInfo(automatic, seededDiscoverableHtmlWebpages);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/assets/html[POST] This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredHtmlWebpages</returns>
        public Pieces.Os.Core.Client.ApiResponse<DiscoveredHtmlWebpages> DiscoveryDiscoverAssetsHtmlWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableHtmlWebpages;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverAssetsHtml";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<DiscoveredHtmlWebpages>("/discovery/discover/assets/html", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverAssetsHtml", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/assets/html[POST] This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredHtmlWebpages</returns>
        public async System.Threading.Tasks.Task<DiscoveredHtmlWebpages> DiscoveryDiscoverAssetsHtmlAsync(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredHtmlWebpages> localVarResponse = await DiscoveryDiscoverAssetsHtmlWithHttpInfoAsync(automatic, seededDiscoverableHtmlWebpages, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/assets/html[POST] This is the discover discover assets html endpoint. The goal of this endpoint is to either take an iterable of urls and pages(an html string) and extract all the assets from the iterable.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableHtmlWebpages"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredHtmlWebpages)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<DiscoveredHtmlWebpages>> DiscoveryDiscoverAssetsHtmlWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableHtmlWebpages seededDiscoverableHtmlWebpages = default(SeededDiscoverableHtmlWebpages), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableHtmlWebpages;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverAssetsHtml";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<DiscoveredHtmlWebpages>("/discovery/discover/assets/html", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverAssetsHtml", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/sensitives [POST] This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredSensitives</returns>
        public DiscoveredSensitives DiscoveryDiscoverSensitives(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredSensitives> localVarResponse = DiscoveryDiscoverSensitivesWithHttpInfo(automatic, seededDiscoverableSensitives);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/sensitives [POST] This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredSensitives</returns>
        public Pieces.Os.Core.Client.ApiResponse<DiscoveredSensitives> DiscoveryDiscoverSensitivesWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableSensitives;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverSensitives";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<DiscoveredSensitives>("/discovery/discover/sensitives", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverSensitives", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/sensitives [POST] This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredSensitives</returns>
        public async System.Threading.Tasks.Task<DiscoveredSensitives> DiscoveryDiscoverSensitivesAsync(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredSensitives> localVarResponse = await DiscoveryDiscoverSensitivesWithHttpInfoAsync(automatic, seededDiscoverableSensitives, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/sensitives [POST] This endpoint will accept an array of text values, and attampt to extract sensitive data out of it.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableSensitives"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredSensitives)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<DiscoveredSensitives>> DiscoveryDiscoverSensitivesWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableSensitives seededDiscoverableSensitives = default(SeededDiscoverableSensitives), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableSensitives;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverSensitives";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<DiscoveredSensitives>("/discovery/discover/sensitives", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverSensitives", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/tags/related [POST] This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>DiscoveredRelatedTags</returns>
        public DiscoveredRelatedTags DiscoveryDiscoverTagsRelated(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredRelatedTags> localVarResponse = DiscoveryDiscoverTagsRelatedWithHttpInfo(automatic, seededDiscoverableRelatedTags);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/tags/related [POST] This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of DiscoveredRelatedTags</returns>
        public Pieces.Os.Core.Client.ApiResponse<DiscoveredRelatedTags> DiscoveryDiscoverTagsRelatedWithHttpInfo(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableRelatedTags;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverTagsRelated";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<DiscoveredRelatedTags>("/discovery/discover/tags/related", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverTagsRelated", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /discovery/discover/tags/related [POST] This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of DiscoveredRelatedTags</returns>
        public async System.Threading.Tasks.Task<DiscoveredRelatedTags> DiscoveryDiscoverTagsRelatedAsync(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<DiscoveredRelatedTags> localVarResponse = await DiscoveryDiscoverTagsRelatedWithHttpInfoAsync(automatic, seededDiscoverableRelatedTags, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /discovery/discover/tags/related [POST] This will take in a tag or multiple tags and return all the tags that are related to the tag or tag provide in the body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="automatic">For most cases set to true. If this is set to true we will handle the behavior automically or else we will not proactively handle specific behavior but we will let the developer decide the behavior. (optional, default to true)</param>
        /// <param name="seededDiscoverableRelatedTags"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (DiscoveredRelatedTags)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<DiscoveredRelatedTags>> DiscoveryDiscoverTagsRelatedWithHttpInfoAsync(bool? automatic = default(bool?), SeededDiscoverableRelatedTags seededDiscoverableRelatedTags = default(SeededDiscoverableRelatedTags), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (automatic != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "automatic", automatic));
            }
            localVarRequestOptions.Data = seededDiscoverableRelatedTags;

            localVarRequestOptions.Operation = "DiscoveryApi.DiscoveryDiscoverTagsRelated";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<DiscoveredRelatedTags>("/discovery/discover/tags/related", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("DiscoveryDiscoverTagsRelated", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
