/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationMessageApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageAssociateAnchor(string message, string anchor, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageAssociateAnchorWithHttpInfo(string message, string anchor, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageAssociateAnnotation(string annotation, string message, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageAssociateAnnotationWithHttpInfo(string annotation, string message, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageAssociatePerson(string message, string person, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageAssociatePersonWithHttpInfo(string message, string person, int operationIndex = 0);
        /// <summary>
        /// Associate a message with a website
        /// </summary>
        /// <remarks>
        /// This will associate a message with a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageAssociateWebsite(string message, string website, int operationIndex = 0);

        /// <summary>
        /// Associate a message with a website
        /// </summary>
        /// <remarks>
        /// This will associate a message with a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageAssociateWebsiteWithHttpInfo(string message, string website, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageDisassociateAnchor(string message, string anchor, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageDisassociateAnchorWithHttpInfo(string message, string anchor, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a message from an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageDisassociateAnnotation(string annotation, string message, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a message from an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageDisassociateAnnotationWithHttpInfo(string annotation, string message, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageDisassociatePerson(string message, string person, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageDisassociatePersonWithHttpInfo(string message, string person, int operationIndex = 0);
        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageDisassociateWebsite(string message, string website, int operationIndex = 0);

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageDisassociateWebsiteWithHttpInfo(string message, string website, int operationIndex = 0);
        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void MessageScoresIncrement(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> MessageScoresIncrementWithHttpInfo(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /message/{message} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific snapshot of a message
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        ConversationMessage MessageSpecificMessageSnapshot(string message, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /message/{message} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific snapshot of a message
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        ApiResponse<ConversationMessage> MessageSpecificMessageSnapshotWithHttpInfo(string message, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /message/update [GET]
        /// </summary>
        /// <remarks>
        /// This will update a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        ConversationMessage MessageSpecificMessageUpdate(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0);

        /// <summary>
        /// /message/update [GET]
        /// </summary>
        /// <remarks>
        /// This will update a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        ApiResponse<ConversationMessage> MessageSpecificMessageUpdateWithHttpInfo(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0);
        /// <summary>
        /// /message/update/value [POST]
        /// </summary>
        /// <remarks>
        /// This will update the value of a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        ConversationMessage MessageUpdateValue(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0);

        /// <summary>
        /// /message/update/value [POST]
        /// </summary>
        /// <remarks>
        /// This will update the value of a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        ApiResponse<ConversationMessage> MessageUpdateValueWithHttpInfo(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationMessageApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageAssociateAnchorAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageAssociateAnchorWithHttpInfoAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageAssociateAnnotationAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageAssociateAnnotationWithHttpInfoAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageAssociatePersonAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a message with a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageAssociatePersonWithHttpInfoAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// Associate a message with a website
        /// </summary>
        /// <remarks>
        /// This will associate a message with a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageAssociateWebsiteAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// Associate a message with a website
        /// </summary>
        /// <remarks>
        /// This will associate a message with a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageAssociateWebsiteWithHttpInfoAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageDisassociateAnchorAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from an anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageDisassociateAnchorWithHttpInfoAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a message from an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageDisassociateAnnotationAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to dissassociate a message from an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageDisassociateAnnotationWithHttpInfoAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageDisassociatePersonAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a person.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageDisassociatePersonWithHttpInfoAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageDisassociateWebsiteAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a message from a website.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageDisassociateWebsiteWithHttpInfoAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task MessageScoresIncrementAsync(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> MessageScoresIncrementWithHttpInfoAsync(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/{message} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific snapshot of a message
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        System.Threading.Tasks.Task<ConversationMessage> MessageSpecificMessageSnapshotAsync(string message, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/{message} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a specific snapshot of a message
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        System.Threading.Tasks.Task<ApiResponse<ConversationMessage>> MessageSpecificMessageSnapshotWithHttpInfoAsync(string message, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/update [GET]
        /// </summary>
        /// <remarks>
        /// This will update a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        System.Threading.Tasks.Task<ConversationMessage> MessageSpecificMessageUpdateAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/update [GET]
        /// </summary>
        /// <remarks>
        /// This will update a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        System.Threading.Tasks.Task<ApiResponse<ConversationMessage>> MessageSpecificMessageUpdateWithHttpInfoAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /message/update/value [POST]
        /// </summary>
        /// <remarks>
        /// This will update the value of a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        System.Threading.Tasks.Task<ConversationMessage> MessageUpdateValueAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /message/update/value [POST]
        /// </summary>
        /// <remarks>
        /// This will update the value of a conversation message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        System.Threading.Tasks.Task<ApiResponse<ConversationMessage>> MessageUpdateValueWithHttpInfoAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationMessageApi : IConversationMessageApiSync, IConversationMessageApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class ConversationMessageApi : IConversationMessageApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationMessageApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ConversationMessageApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationMessageApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ConversationMessageApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationMessageApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public ConversationMessageApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationMessageApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public ConversationMessageApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST] This will associate a message with an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageAssociateAnchor(string message, string anchor, int operationIndex = 0)
        {
            MessageAssociateAnchorWithHttpInfo(message, anchor);
        }

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST] This will associate a message with an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageAssociateAnchorWithHttpInfo(string message, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationMessageApi->MessageAssociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST] This will associate a message with an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageAssociateAnchorAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageAssociateAnchorWithHttpInfoAsync(message, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/anchors/associate/{anchor} [POST] This will associate a message with an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageAssociateAnchorWithHttpInfoAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationMessageApi->MessageAssociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST] This will associate a message with an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageAssociateAnnotation(string annotation, string message, int operationIndex = 0)
        {
            MessageAssociateAnnotationWithHttpInfo(annotation, message);
        }

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST] This will associate a message with an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageAssociateAnnotationWithHttpInfo(string annotation, string message, int operationIndex = 0)
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling ConversationMessageApi->MessageAssociateAnnotation");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateAnnotation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/annotations/associate/{annotation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST] This will associate a message with an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageAssociateAnnotationAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageAssociateAnnotationWithHttpInfoAsync(annotation, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/annotations/associate/{annotation} [POST] This will associate a message with an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageAssociateAnnotationWithHttpInfoAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling ConversationMessageApi->MessageAssociateAnnotation");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateAnnotation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/annotations/associate/{annotation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST] This will associate a message with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageAssociatePerson(string message, string person, int operationIndex = 0)
        {
            MessageAssociatePersonWithHttpInfo(message, person);
        }

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST] This will associate a message with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageAssociatePersonWithHttpInfo(string message, string person, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling ConversationMessageApi->MessageAssociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/persons/associate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST] This will associate a message with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageAssociatePersonAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageAssociatePersonWithHttpInfoAsync(message, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/persons/associate/{person} [POST] This will associate a message with a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageAssociatePersonWithHttpInfoAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling ConversationMessageApi->MessageAssociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/persons/associate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Associate a message with a website This will associate a message with a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageAssociateWebsite(string message, string website, int operationIndex = 0)
        {
            MessageAssociateWebsiteWithHttpInfo(message, website);
        }

        /// <summary>
        /// Associate a message with a website This will associate a message with a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageAssociateWebsiteWithHttpInfo(string message, string website, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationMessageApi->MessageAssociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/websites/associate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Associate a message with a website This will associate a message with a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageAssociateWebsiteAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageAssociateWebsiteWithHttpInfoAsync(message, website, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Associate a message with a website This will associate a message with a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageAssociateWebsiteWithHttpInfoAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageAssociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationMessageApi->MessageAssociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/websites/associate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST] This will enable us to disassociate a message from an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageDisassociateAnchor(string message, string anchor, int operationIndex = 0)
        {
            MessageDisassociateAnchorWithHttpInfo(message, anchor);
        }

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST] This will enable us to disassociate a message from an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageDisassociateAnchorWithHttpInfo(string message, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationMessageApi->MessageDisassociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST] This will enable us to disassociate a message from an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageDisassociateAnchorAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageDisassociateAnchorWithHttpInfoAsync(message, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/anchors/disassociate/{anchor} [POST] This will enable us to disassociate a message from an anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageDisassociateAnchorWithHttpInfoAsync(string message, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationMessageApi->MessageDisassociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST] This will enable us to dissassociate a message from an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageDisassociateAnnotation(string annotation, string message, int operationIndex = 0)
        {
            MessageDisassociateAnnotationWithHttpInfo(annotation, message);
        }

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST] This will enable us to dissassociate a message from an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageDisassociateAnnotationWithHttpInfo(string annotation, string message, int operationIndex = 0)
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling ConversationMessageApi->MessageDisassociateAnnotation");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateAnnotation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/annotations/disassociate/{annotation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST] This will enable us to dissassociate a message from an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageDisassociateAnnotationAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageDisassociateAnnotationWithHttpInfoAsync(annotation, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/annotations/disassociate/{annotation} [POST] This will enable us to dissassociate a message from an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageDisassociateAnnotationWithHttpInfoAsync(string annotation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling ConversationMessageApi->MessageDisassociateAnnotation");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateAnnotation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/annotations/disassociate/{annotation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST] This will enable us to disassociate a message from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageDisassociatePerson(string message, string person, int operationIndex = 0)
        {
            MessageDisassociatePersonWithHttpInfo(message, person);
        }

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST] This will enable us to disassociate a message from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageDisassociatePersonWithHttpInfo(string message, string person, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling ConversationMessageApi->MessageDisassociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST] This will enable us to disassociate a message from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageDisassociatePersonAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageDisassociatePersonWithHttpInfoAsync(message, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/persons/disassociate/{person} [POST] This will enable us to disassociate a message from a person.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageDisassociatePersonWithHttpInfoAsync(string message, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling ConversationMessageApi->MessageDisassociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST] This will enable us to disassociate a message from a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageDisassociateWebsite(string message, string website, int operationIndex = 0)
        {
            MessageDisassociateWebsiteWithHttpInfo(message, website);
        }

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST] This will enable us to disassociate a message from a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageDisassociateWebsiteWithHttpInfo(string message, string website, int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationMessageApi->MessageDisassociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST] This will enable us to disassociate a message from a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageDisassociateWebsiteAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageDisassociateWebsiteWithHttpInfoAsync(message, website, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /message/{message}/websites/disassociate/{website} [POST] This will enable us to disassociate a message from a website.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageDisassociateWebsiteWithHttpInfoAsync(string message, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageDisassociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationMessageApi->MessageDisassociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void MessageScoresIncrement(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            MessageScoresIncrementWithHttpInfo(message, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> MessageScoresIncrementWithHttpInfo(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/message/{message}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task MessageScoresIncrementAsync(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await MessageScoresIncrementWithHttpInfoAsync(message, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/message/{message}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> MessageScoresIncrementWithHttpInfoAsync(string message, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/message/{message}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message} [GET] This will get a specific snapshot of a message
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        public ConversationMessage MessageSpecificMessageSnapshot(string message, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = MessageSpecificMessageSnapshotWithHttpInfo(message, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/{message} [GET] This will get a specific snapshot of a message
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        public Pieces.Os.Core.Client.ApiResponse<ConversationMessage> MessageSpecificMessageSnapshotWithHttpInfo(string message, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageSpecificMessageSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageSpecificMessageSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<ConversationMessage>("/message/{message}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageSpecificMessageSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/{message} [GET] This will get a specific snapshot of a message
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        public async System.Threading.Tasks.Task<ConversationMessage> MessageSpecificMessageSnapshotAsync(string message, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = await MessageSpecificMessageSnapshotWithHttpInfoAsync(message, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/{message} [GET] This will get a specific snapshot of a message
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ConversationMessage>> MessageSpecificMessageSnapshotWithHttpInfoAsync(string message, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationMessageApi->MessageSpecificMessageSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageSpecificMessageSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<ConversationMessage>("/message/{message}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageSpecificMessageSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/update [GET] This will update a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        public ConversationMessage MessageSpecificMessageUpdate(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = MessageSpecificMessageUpdateWithHttpInfo(transferables, conversationMessage);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/update [GET] This will update a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        public Pieces.Os.Core.Client.ApiResponse<ConversationMessage> MessageSpecificMessageUpdateWithHttpInfo(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversationMessage;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageSpecificMessageUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<ConversationMessage>("/message/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageSpecificMessageUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/update [GET] This will update a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        public async System.Threading.Tasks.Task<ConversationMessage> MessageSpecificMessageUpdateAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = await MessageSpecificMessageUpdateWithHttpInfoAsync(transferables, conversationMessage, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/update [GET] This will update a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ConversationMessage>> MessageSpecificMessageUpdateWithHttpInfoAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversationMessage;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageSpecificMessageUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<ConversationMessage>("/message/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageSpecificMessageUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/update/value [POST] This will update the value of a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessage</returns>
        public ConversationMessage MessageUpdateValue(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = MessageUpdateValueWithHttpInfo(transferables, conversationMessage);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/update/value [POST] This will update the value of a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessage</returns>
        public Pieces.Os.Core.Client.ApiResponse<ConversationMessage> MessageUpdateValueWithHttpInfo(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversationMessage;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageUpdateValue";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<ConversationMessage>("/message/update/value", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageUpdateValue", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /message/update/value [POST] This will update the value of a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessage</returns>
        public async System.Threading.Tasks.Task<ConversationMessage> MessageUpdateValueAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessage> localVarResponse = await MessageUpdateValueWithHttpInfoAsync(transferables, conversationMessage, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /message/update/value [POST] This will update the value of a conversation message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversationMessage"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessage)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ConversationMessage>> MessageUpdateValueWithHttpInfoAsync(bool? transferables = default(bool?), ConversationMessage conversationMessage = default(ConversationMessage), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversationMessage;

            localVarRequestOptions.Operation = "ConversationMessageApi.MessageUpdateValue";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<ConversationMessage>("/message/update/value", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("MessageUpdateValue", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
