/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, associating them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationAssociateAnchor(string conversation, string anchor, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, associating them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationAssociateAnchorWithHttpInfo(string conversation, string anchor, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, associating the two together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationAssociateAsset(string conversation, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, associating the two together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationAssociateAssetWithHttpInfo(string conversation, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationAssociateGroundingTemporalRangeWorkstream(string conversation, string range, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfo(string conversation, string range, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the website and the conversation, and associate them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationAssociateWebsite(string conversation, string website, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the website and the conversation, and associate them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationAssociateWebsiteWithHttpInfo(string conversation, string website, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationAssociateWorkstreamSummary(string conversation, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationAssociateWorkstreamSummaryWithHttpInfo(string conversation, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationDisassociateAnchor(string conversation, string anchor, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationDisassociateAnchorWithHttpInfo(string conversation, string anchor, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, effectively disassociating them.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationDisassociateAsset(string conversation, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, effectively disassociating them.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationDisassociateAssetWithHttpInfo(string conversation, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationDisassociateGroundingTemporalRangeWorkstream(string conversation, string range, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfo(string conversation, string range, int operationIndex = 0);
        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Allows us to disassociate a conversation from a specific website
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationDisassociateWebsite(string conversation, string website, int operationIndex = 0);

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Allows us to disassociate a conversation from a specific website
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationDisassociateWebsiteWithHttpInfo(string conversation, string website, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationDisassociateWorkstreamSummary(string conversation, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationDisassociateWorkstreamSummaryWithHttpInfo(string conversation, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        Conversation ConversationGetSpecificConversation(string conversation, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        ApiResponse<Conversation> ConversationGetSpecificConversationWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationGroundingMessagesAssociateMessage(string conversation, string message, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationGroundingMessagesAssociateMessageWithHttpInfo(string conversation, string message, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationGroundingMessagesDisassociateMessage(string conversation, string message, int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationGroundingMessagesDisassociateMessageWithHttpInfo(string conversation, string message, int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void ConversationScoresIncrement(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ConversationScoresIncrementWithHttpInfo(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/messages [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves messages specific to a particular conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessages</returns>
        ConversationMessages ConversationSpecificConversationMessages(string conversation, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/messages [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves messages specific to a particular conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessages</returns>
        ApiResponse<ConversationMessages> ConversationSpecificConversationMessagesWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/rename [POST]
        /// </summary>
        /// <remarks>
        /// Renames a specific conversation using machine learning (ML) techniques.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        Conversation ConversationSpecificConversationRename(string conversation, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/rename [POST]
        /// </summary>
        /// <remarks>
        /// Renames a specific conversation using machine learning (ML) techniques.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        ApiResponse<Conversation> ConversationSpecificConversationRenameWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/summarize [POST]
        /// </summary>
        /// <remarks>
        /// Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationSummarizeOutput</returns>
        ConversationSummarizeOutput ConversationSummarize(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/summarize [POST]
        /// </summary>
        /// <remarks>
        /// Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationSummarizeOutput</returns>
        ApiResponse<ConversationSummarizeOutput> ConversationSummarizeWithHttpInfo(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0);
        /// <summary>
        /// /conversation/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        Conversation ConversationUpdate(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0);

        /// <summary>
        /// /conversation/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        ApiResponse<Conversation> ConversationUpdateWithHttpInfo(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0);
        /// <summary>
        /// /conversation/{conversation}/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedConversationMessages</returns>
        SearchedConversationMessages SearchConversationSpecificMessages(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);

        /// <summary>
        /// /conversation/{conversation}/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedConversationMessages</returns>
        ApiResponse<SearchedConversationMessages> SearchConversationSpecificMessagesWithHttpInfo(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, associating them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationAssociateAnchorAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, associating them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationAssociateAnchorWithHttpInfoAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, associating the two together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationAssociateAssetAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, associating the two together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationAssociateAssetWithHttpInfoAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationAssociateGroundingTemporalRangeWorkstreamAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the website and the conversation, and associate them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationAssociateWebsiteAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the website and the conversation, and associate them together.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationAssociateWebsiteWithHttpInfoAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationAssociateWorkstreamSummaryAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationAssociateWorkstreamSummaryWithHttpInfoAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationDisassociateAnchorAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationDisassociateAnchorWithHttpInfoAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, effectively disassociating them.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationDisassociateAssetAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Updates both the asset and the conversation, effectively disassociating them.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationDisassociateAssetWithHttpInfoAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationDisassociateGroundingTemporalRangeWorkstreamAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Allows us to disassociate a conversation from a specific website
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationDisassociateWebsiteAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Allows us to disassociate a conversation from a specific website
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationDisassociateWebsiteWithHttpInfoAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationDisassociateWorkstreamSummaryAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationDisassociateWorkstreamSummaryWithHttpInfoAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        System.Threading.Tasks.Task<Conversation> ConversationGetSpecificConversationAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation} [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        System.Threading.Tasks.Task<ApiResponse<Conversation>> ConversationGetSpecificConversationWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationGroundingMessagesAssociateMessageAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationGroundingMessagesAssociateMessageWithHttpInfoAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationGroundingMessagesDisassociateMessageAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationGroundingMessagesDisassociateMessageWithHttpInfoAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ConversationScoresIncrementAsync(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ConversationScoresIncrementWithHttpInfoAsync(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/messages [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves messages specific to a particular conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessages</returns>
        System.Threading.Tasks.Task<ConversationMessages> ConversationSpecificConversationMessagesAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/messages [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves messages specific to a particular conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessages)</returns>
        System.Threading.Tasks.Task<ApiResponse<ConversationMessages>> ConversationSpecificConversationMessagesWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/rename [POST]
        /// </summary>
        /// <remarks>
        /// Renames a specific conversation using machine learning (ML) techniques.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        System.Threading.Tasks.Task<Conversation> ConversationSpecificConversationRenameAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/rename [POST]
        /// </summary>
        /// <remarks>
        /// Renames a specific conversation using machine learning (ML) techniques.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        System.Threading.Tasks.Task<ApiResponse<Conversation>> ConversationSpecificConversationRenameWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/summarize [POST]
        /// </summary>
        /// <remarks>
        /// Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationSummarizeOutput</returns>
        System.Threading.Tasks.Task<ConversationSummarizeOutput> ConversationSummarizeAsync(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/summarize [POST]
        /// </summary>
        /// <remarks>
        /// Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationSummarizeOutput)</returns>
        System.Threading.Tasks.Task<ApiResponse<ConversationSummarizeOutput>> ConversationSummarizeWithHttpInfoAsync(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        System.Threading.Tasks.Task<Conversation> ConversationUpdateAsync(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/update [POST]
        /// </summary>
        /// <remarks>
        /// Updates a specific conversation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        System.Threading.Tasks.Task<ApiResponse<Conversation>> ConversationUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /conversation/{conversation}/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedConversationMessages</returns>
        System.Threading.Tasks.Task<SearchedConversationMessages> SearchConversationSpecificMessagesAsync(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /conversation/{conversation}/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedConversationMessages)</returns>
        System.Threading.Tasks.Task<ApiResponse<SearchedConversationMessages>> SearchConversationSpecificMessagesWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IConversationApi : IConversationApiSync, IConversationApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class ConversationApi : IConversationApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ConversationApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ConversationApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public ConversationApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ConversationApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public ConversationApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST] Updates both the anchor and the conversation, associating them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationAssociateAnchor(string conversation, string anchor, int operationIndex = 0)
        {
            ConversationAssociateAnchorWithHttpInfo(conversation, anchor);
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST] Updates both the anchor and the conversation, associating them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationAssociateAnchorWithHttpInfo(string conversation, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationApi->ConversationAssociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST] Updates both the anchor and the conversation, associating them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationAssociateAnchorAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationAssociateAnchorWithHttpInfoAsync(conversation, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/associate/{anchor} [POST] Updates both the anchor and the conversation, associating them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationAssociateAnchorWithHttpInfoAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationApi->ConversationAssociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST] Updates both the asset and the conversation, associating the two together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationAssociateAsset(string conversation, Guid asset, int operationIndex = 0)
        {
            ConversationAssociateAssetWithHttpInfo(conversation, asset);
        }

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST] Updates both the asset and the conversation, associating the two together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationAssociateAssetWithHttpInfo(string conversation, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/assets/associate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST] Updates both the asset and the conversation, associating the two together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationAssociateAssetAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationAssociateAssetWithHttpInfoAsync(conversation, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/assets/associate/{asset} [POST] Updates both the asset and the conversation, associating the two together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationAssociateAssetWithHttpInfoAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/assets/associate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST] This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationAssociateGroundingTemporalRangeWorkstream(string conversation, string range, int operationIndex = 0)
        {
            ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfo(conversation, range);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST] This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfo(string conversation, string range, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateGroundingTemporalRangeWorkstream");
            }

            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling ConversationApi->ConversationAssociateGroundingTemporalRangeWorkstream");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateGroundingTemporalRangeWorkstream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/grounding/temporal_range/workstreams/associate/{range}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateGroundingTemporalRangeWorkstream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST] This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationAssociateGroundingTemporalRangeWorkstreamAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(conversation, range, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST] This will associate a workstream(range) with a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationAssociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateGroundingTemporalRangeWorkstream");
            }

            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling ConversationApi->ConversationAssociateGroundingTemporalRangeWorkstream");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateGroundingTemporalRangeWorkstream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/grounding/temporal_range/workstreams/associate/{range}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateGroundingTemporalRangeWorkstream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST] Updates both the website and the conversation, and associate them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationAssociateWebsite(string conversation, string website, int operationIndex = 0)
        {
            ConversationAssociateWebsiteWithHttpInfo(conversation, website);
        }

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST] Updates both the website and the conversation, and associate them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationAssociateWebsiteWithHttpInfo(string conversation, string website, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationApi->ConversationAssociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/websites/associate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST] Updates both the website and the conversation, and associate them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationAssociateWebsiteAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationAssociateWebsiteWithHttpInfoAsync(conversation, website, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/websites/associate/{website} [POST] Updates both the website and the conversation, and associate them together.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationAssociateWebsiteWithHttpInfoAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationApi->ConversationAssociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/websites/associate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationAssociateWorkstreamSummary(string conversation, string workstreamSummary, int operationIndex = 0)
        {
            ConversationAssociateWorkstreamSummaryWithHttpInfo(conversation, workstreamSummary);
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationAssociateWorkstreamSummaryWithHttpInfo(string conversation, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling ConversationApi->ConversationAssociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationAssociateWorkstreamSummaryAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationAssociateWorkstreamSummaryWithHttpInfoAsync(conversation, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a conversation with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationAssociateWorkstreamSummaryWithHttpInfoAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling ConversationApi->ConversationAssociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST] Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationDisassociateAnchor(string conversation, string anchor, int operationIndex = 0)
        {
            ConversationDisassociateAnchorWithHttpInfo(conversation, anchor);
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST] Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationDisassociateAnchorWithHttpInfo(string conversation, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationApi->ConversationDisassociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST] Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationDisassociateAnchorAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationDisassociateAnchorWithHttpInfoAsync(conversation, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/anchors/disassociate/{anchor} [POST] Updates both the anchor and the conversation, deleting (disassociating) them simultaneously.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationDisassociateAnchorWithHttpInfoAsync(string conversation, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateAnchor");
            }

            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling ConversationApi->ConversationDisassociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST] Updates both the asset and the conversation, effectively disassociating them.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationDisassociateAsset(string conversation, Guid asset, int operationIndex = 0)
        {
            ConversationDisassociateAssetWithHttpInfo(conversation, asset);
        }

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST] Updates both the asset and the conversation, effectively disassociating them.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationDisassociateAssetWithHttpInfo(string conversation, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST] Updates both the asset and the conversation, effectively disassociating them.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationDisassociateAssetAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationDisassociateAssetWithHttpInfoAsync(conversation, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/assets/disassociate/{asset} [POST] Updates both the asset and the conversation, effectively disassociating them.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationDisassociateAssetWithHttpInfoAsync(string conversation, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST] This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationDisassociateGroundingTemporalRangeWorkstream(string conversation, string range, int operationIndex = 0)
        {
            ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfo(conversation, range);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST] This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfo(string conversation, string range, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateGroundingTemporalRangeWorkstream");
            }

            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling ConversationApi->ConversationDisassociateGroundingTemporalRangeWorkstream");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateGroundingTemporalRangeWorkstream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateGroundingTemporalRangeWorkstream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST] This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationDisassociateGroundingTemporalRangeWorkstreamAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(conversation, range, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST] This will enable us to disassociate a workstream(range) from a conversation. This will do the same thing as the range equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="range">This is a identifier that is used to identify a specific range.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationDisassociateGroundingTemporalRangeWorkstreamWithHttpInfoAsync(string conversation, string range, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateGroundingTemporalRangeWorkstream");
            }

            // verify the required parameter 'range' is set
            if (range == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'range' when calling ConversationApi->ConversationDisassociateGroundingTemporalRangeWorkstream");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("range", Pieces.Os.Core.Client.ClientUtils.ParameterToString(range)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateGroundingTemporalRangeWorkstream";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateGroundingTemporalRangeWorkstream", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST] Allows us to disassociate a conversation from a specific website
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationDisassociateWebsite(string conversation, string website, int operationIndex = 0)
        {
            ConversationDisassociateWebsiteWithHttpInfo(conversation, website);
        }

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST] Allows us to disassociate a conversation from a specific website
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationDisassociateWebsiteWithHttpInfo(string conversation, string website, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationApi->ConversationDisassociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST] Allows us to disassociate a conversation from a specific website
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationDisassociateWebsiteAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationDisassociateWebsiteWithHttpInfoAsync(conversation, website, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /website/{website}/websites/disassociate/{website} [POST] Allows us to disassociate a conversation from a specific website
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationDisassociateWebsiteWithHttpInfoAsync(string conversation, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateWebsite");
            }

            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling ConversationApi->ConversationDisassociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationDisassociateWorkstreamSummary(string conversation, string workstreamSummary, int operationIndex = 0)
        {
            ConversationDisassociateWorkstreamSummaryWithHttpInfo(conversation, workstreamSummary);
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationDisassociateWorkstreamSummaryWithHttpInfo(string conversation, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling ConversationApi->ConversationDisassociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationDisassociateWorkstreamSummaryAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationDisassociateWorkstreamSummaryWithHttpInfoAsync(conversation, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an conversation from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationDisassociateWorkstreamSummaryWithHttpInfoAsync(string conversation, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling ConversationApi->ConversationDisassociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation} [GET] Retrieves a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        public Conversation ConversationGetSpecificConversation(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = ConversationGetSpecificConversationWithHttpInfo(conversation, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation} [GET] Retrieves a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        public Pieces.Os.Core.Client.ApiResponse<Conversation> ConversationGetSpecificConversationWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGetSpecificConversation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationGetSpecificConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Conversation>("/conversation/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGetSpecificConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation} [GET] Retrieves a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        public async System.Threading.Tasks.Task<Conversation> ConversationGetSpecificConversationAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = await ConversationGetSpecificConversationWithHttpInfoAsync(conversation, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation} [GET] Retrieves a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Conversation>> ConversationGetSpecificConversationWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGetSpecificConversation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationGetSpecificConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Conversation>("/conversation/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGetSpecificConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST] Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationGroundingMessagesAssociateMessage(string conversation, string message, int operationIndex = 0)
        {
            ConversationGroundingMessagesAssociateMessageWithHttpInfo(conversation, message);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST] Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationGroundingMessagesAssociateMessageWithHttpInfo(string conversation, string message, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGroundingMessagesAssociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationApi->ConversationGroundingMessagesAssociateMessage");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationGroundingMessagesAssociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/grounding/messages/associate/{message}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGroundingMessagesAssociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST] Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationGroundingMessagesAssociateMessageAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationGroundingMessagesAssociateMessageWithHttpInfoAsync(conversation, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/associate/{message} [POST] Stores the grounding context for a conversation. It allows to associate a message with the conversation&#39;s grounding object, facilitating contextual understanding and management of the conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationGroundingMessagesAssociateMessageWithHttpInfoAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGroundingMessagesAssociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationApi->ConversationGroundingMessagesAssociateMessage");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationGroundingMessagesAssociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/grounding/messages/associate/{message}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGroundingMessagesAssociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST] Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationGroundingMessagesDisassociateMessage(string conversation, string message, int operationIndex = 0)
        {
            ConversationGroundingMessagesDisassociateMessageWithHttpInfo(conversation, message);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST] Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationGroundingMessagesDisassociateMessageWithHttpInfo(string conversation, string message, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGroundingMessagesDisassociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationApi->ConversationGroundingMessagesDisassociateMessage");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationGroundingMessagesDisassociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/grounding/messages/disassociate/{message}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGroundingMessagesDisassociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST] Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationGroundingMessagesDisassociateMessageAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationGroundingMessagesDisassociateMessageWithHttpInfoAsync(conversation, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/grounding/messages/disassociate/{message} [POST] Removes a specific grounding context for a conversation, and allows us to disassociate a message from the conversation&#39;s grounding object.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationGroundingMessagesDisassociateMessageWithHttpInfoAsync(string conversation, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationGroundingMessagesDisassociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling ConversationApi->ConversationGroundingMessagesDisassociateMessage");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "ConversationApi.ConversationGroundingMessagesDisassociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/grounding/messages/disassociate/{message}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationGroundingMessagesDisassociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST] Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void ConversationScoresIncrement(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            ConversationScoresIncrementWithHttpInfo(conversation, seededScoreIncrement);
        }

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST] Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> ConversationScoresIncrementWithHttpInfo(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "ConversationApi.ConversationScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/conversation/{conversation}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST] Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ConversationScoresIncrementAsync(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await ConversationScoresIncrementWithHttpInfoAsync(conversation, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /conversation/{conversation}/scores/increment [POST] Increment scores associated with a conversation. It accepts a SeededScoreIncrement object as input to adjust the scores accordingly based on the provided data.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> ConversationScoresIncrementWithHttpInfoAsync(string conversation, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "ConversationApi.ConversationScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/conversation/{conversation}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/messages [GET] Retrieves messages specific to a particular conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationMessages</returns>
        public ConversationMessages ConversationSpecificConversationMessages(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessages> localVarResponse = ConversationSpecificConversationMessagesWithHttpInfo(conversation, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/messages [GET] Retrieves messages specific to a particular conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationMessages</returns>
        public Pieces.Os.Core.Client.ApiResponse<ConversationMessages> ConversationSpecificConversationMessagesWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSpecificConversationMessages");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationSpecificConversationMessages";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<ConversationMessages>("/conversation/{conversation}/messages", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSpecificConversationMessages", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/messages [GET] Retrieves messages specific to a particular conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationMessages</returns>
        public async System.Threading.Tasks.Task<ConversationMessages> ConversationSpecificConversationMessagesAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationMessages> localVarResponse = await ConversationSpecificConversationMessagesWithHttpInfoAsync(conversation, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/messages [GET] Retrieves messages specific to a particular conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationMessages)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ConversationMessages>> ConversationSpecificConversationMessagesWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSpecificConversationMessages");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationSpecificConversationMessages";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<ConversationMessages>("/conversation/{conversation}/messages", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSpecificConversationMessages", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/rename [POST] Renames a specific conversation using machine learning (ML) techniques.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        public Conversation ConversationSpecificConversationRename(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = ConversationSpecificConversationRenameWithHttpInfo(conversation, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/rename [POST] Renames a specific conversation using machine learning (ML) techniques.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        public Pieces.Os.Core.Client.ApiResponse<Conversation> ConversationSpecificConversationRenameWithHttpInfo(string conversation, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSpecificConversationRename");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationSpecificConversationRename";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Conversation>("/conversation/{conversation}/rename", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSpecificConversationRename", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/rename [POST] Renames a specific conversation using machine learning (ML) techniques.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        public async System.Threading.Tasks.Task<Conversation> ConversationSpecificConversationRenameAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = await ConversationSpecificConversationRenameWithHttpInfoAsync(conversation, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/rename [POST] Renames a specific conversation using machine learning (ML) techniques.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Conversation>> ConversationSpecificConversationRenameWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSpecificConversationRename");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "ConversationApi.ConversationSpecificConversationRename";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Conversation>("/conversation/{conversation}/rename", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSpecificConversationRename", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/summarize [POST] Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ConversationSummarizeOutput</returns>
        public ConversationSummarizeOutput ConversationSummarize(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationSummarizeOutput> localVarResponse = ConversationSummarizeWithHttpInfo(conversation, conversationSummarizeInput);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/summarize [POST] Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ConversationSummarizeOutput</returns>
        public Pieces.Os.Core.Client.ApiResponse<ConversationSummarizeOutput> ConversationSummarizeWithHttpInfo(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSummarize");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.Data = conversationSummarizeInput;

            localVarRequestOptions.Operation = "ConversationApi.ConversationSummarize";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<ConversationSummarizeOutput>("/conversation/{conversation}/summarize", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSummarize", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/summarize [POST] Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ConversationSummarizeOutput</returns>
        public async System.Threading.Tasks.Task<ConversationSummarizeOutput> ConversationSummarizeAsync(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ConversationSummarizeOutput> localVarResponse = await ConversationSummarizeWithHttpInfoAsync(conversation, conversationSummarizeInput, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/summarize [POST] Generates a summary of a given conversation and saves it as an annotation associated with the conversation. It returns a reference to the annotation, which serves as the summary.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="conversationSummarizeInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ConversationSummarizeOutput)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ConversationSummarizeOutput>> ConversationSummarizeWithHttpInfoAsync(string conversation, ConversationSummarizeInput conversationSummarizeInput = default(ConversationSummarizeInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->ConversationSummarize");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            localVarRequestOptions.Data = conversationSummarizeInput;

            localVarRequestOptions.Operation = "ConversationApi.ConversationSummarize";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<ConversationSummarizeOutput>("/conversation/{conversation}/summarize", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationSummarize", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/update [POST] Updates a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversation</returns>
        public Conversation ConversationUpdate(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = ConversationUpdateWithHttpInfo(transferables, conversation);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/update [POST] Updates a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversation</returns>
        public Pieces.Os.Core.Client.ApiResponse<Conversation> ConversationUpdateWithHttpInfo(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversation;

            localVarRequestOptions.Operation = "ConversationApi.ConversationUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Conversation>("/conversation/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/update [POST] Updates a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversation</returns>
        public async System.Threading.Tasks.Task<Conversation> ConversationUpdateAsync(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Conversation> localVarResponse = await ConversationUpdateWithHttpInfoAsync(transferables, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/update [POST] Updates a specific conversation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="conversation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversation)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Conversation>> ConversationUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Conversation conversation = default(Conversation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = conversation;

            localVarRequestOptions.Operation = "ConversationApi.ConversationUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Conversation>("/conversation/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ConversationUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/search [POST] This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedConversationMessages</returns>
        public SearchedConversationMessages SearchConversationSpecificMessages(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedConversationMessages> localVarResponse = SearchConversationSpecificMessagesWithHttpInfo(conversation, transferables, searchInput);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/search [POST] This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedConversationMessages</returns>
        public Pieces.Os.Core.Client.ApiResponse<SearchedConversationMessages> SearchConversationSpecificMessagesWithHttpInfo(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->SearchConversationSpecificMessages");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "ConversationApi.SearchConversationSpecificMessages";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<SearchedConversationMessages>("/conversation/{conversation}/search", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SearchConversationSpecificMessages", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /conversation/{conversation}/search [POST] This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedConversationMessages</returns>
        public async System.Threading.Tasks.Task<SearchedConversationMessages> SearchConversationSpecificMessagesAsync(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedConversationMessages> localVarResponse = await SearchConversationSpecificMessagesWithHttpInfoAsync(conversation, transferables, searchInput, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /conversation/{conversation}/search [POST] This will search a specific conversation for a match  note: here we will only search the conversationMessages for this given Conversation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedConversationMessages)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<SearchedConversationMessages>> SearchConversationSpecificMessagesWithHttpInfoAsync(string conversation, bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling ConversationApi->SearchConversationSpecificMessages");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "ConversationApi.SearchConversationSpecificMessages";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<SearchedConversationMessages>("/conversation/{conversation}/search", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SearchConversationSpecificMessages", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
