/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IBackupApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /backup [POST]
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void Backup(Assets assets = default(Assets), int operationIndex = 0);

        /// <summary>
        /// /backup [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> BackupWithHttpInfo(Assets assets = default(Assets), int operationIndex = 0);
        /// <summary>
        /// /backup/asset [POST]
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void BackupAsset(Asset asset = default(Asset), int operationIndex = 0);

        /// <summary>
        /// /backup/asset [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> BackupAssetWithHttpInfo(Asset asset = default(Asset), int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/restore [POST]
        /// </summary>
        /// <remarks>
        /// Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Backup</returns>
        Backup BackupRestoreSpecificBackup(string backup, Backup backup2 = default(Backup), int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/restore [POST]
        /// </summary>
        /// <remarks>
        /// Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Backup</returns>
        ApiResponse<Backup> BackupRestoreSpecificBackupWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/restore/streamed [POST]
        /// </summary>
        /// <remarks>
        /// This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStreamedProgress</returns>
        BackupStreamedProgress BackupRestoreSpecificBackupStreamed(string backup, Backup backup2 = default(Backup), int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST]
        /// </summary>
        /// <remarks>
        /// This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStreamedProgress</returns>
        ApiResponse<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS]
        /// </summary>
        /// <remarks>
        /// WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStreamedProgress</returns>
        BackupStreamedProgress BackupRestoreSpecificBackupStreamedWebsocket(string backup, Backup backup2 = default(Backup), int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS]
        /// </summary>
        /// <remarks>
        /// WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStreamedProgress</returns>
        ApiResponse<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0);
        /// <summary>
        /// /backup/{backup} [GET]
        /// </summary>
        /// <remarks>
        /// This will just get the metadata associated with a specific backup.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Backup</returns>
        Backup BackupSpecificBackupSnapshot(string backup, int operationIndex = 0);

        /// <summary>
        /// /backup/{backup} [GET]
        /// </summary>
        /// <remarks>
        /// This will just get the metadata associated with a specific backup.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Backup</returns>
        ApiResponse<Backup> BackupSpecificBackupSnapshotWithHttpInfo(string backup, int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/creation/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void BackupSpecificCreationCancel(string backup, int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> BackupSpecificCreationCancelWithHttpInfo(string backup, int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/creation/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStatus</returns>
        BackupStatus BackupSpecificCreationStatus(string backup, int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/creation/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStatus</returns>
        ApiResponse<BackupStatus> BackupSpecificCreationStatusWithHttpInfo(string backup, int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void BackupSpecificRestorationCancel(string backup, Backup backup2 = default(Backup), int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> BackupSpecificRestorationCancelWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0);
        /// <summary>
        /// /backup/{backup}/restoration/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStatus</returns>
        BackupStatus BackupSpecificRestorationStatus(string backup, int operationIndex = 0);

        /// <summary>
        /// /backup/{backup}/restoration/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStatus</returns>
        ApiResponse<BackupStatus> BackupSpecificRestorationStatusWithHttpInfo(string backup, int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IBackupApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /backup [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task BackupAsync(Assets assets = default(Assets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> BackupWithHttpInfoAsync(Assets assets = default(Assets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/asset [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task BackupAssetAsync(Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/asset [POST]
        /// </summary>
        /// <remarks>
        /// 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> BackupAssetWithHttpInfoAsync(Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/restore [POST]
        /// </summary>
        /// <remarks>
        /// Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Backup</returns>
        System.Threading.Tasks.Task<Backup> BackupRestoreSpecificBackupAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/restore [POST]
        /// </summary>
        /// <remarks>
        /// Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Backup)</returns>
        System.Threading.Tasks.Task<ApiResponse<Backup>> BackupRestoreSpecificBackupWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/restore/streamed [POST]
        /// </summary>
        /// <remarks>
        /// This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStreamedProgress</returns>
        System.Threading.Tasks.Task<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST]
        /// </summary>
        /// <remarks>
        /// This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStreamedProgress)</returns>
        System.Threading.Tasks.Task<ApiResponse<BackupStreamedProgress>> BackupRestoreSpecificBackupStreamedWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS]
        /// </summary>
        /// <remarks>
        /// WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStreamedProgress</returns>
        System.Threading.Tasks.Task<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWebsocketAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS]
        /// </summary>
        /// <remarks>
        /// WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStreamedProgress)</returns>
        System.Threading.Tasks.Task<ApiResponse<BackupStreamedProgress>> BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup} [GET]
        /// </summary>
        /// <remarks>
        /// This will just get the metadata associated with a specific backup.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Backup</returns>
        System.Threading.Tasks.Task<Backup> BackupSpecificBackupSnapshotAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup} [GET]
        /// </summary>
        /// <remarks>
        /// This will just get the metadata associated with a specific backup.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Backup)</returns>
        System.Threading.Tasks.Task<ApiResponse<Backup>> BackupSpecificBackupSnapshotWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/creation/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task BackupSpecificCreationCancelAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> BackupSpecificCreationCancelWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/creation/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStatus</returns>
        System.Threading.Tasks.Task<BackupStatus> BackupSpecificCreationStatusAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/creation/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<BackupStatus>> BackupSpecificCreationStatusWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task BackupSpecificRestorationCancelAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST]
        /// </summary>
        /// <remarks>
        /// This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> BackupSpecificRestorationCancelWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /backup/{backup}/restoration/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStatus</returns>
        System.Threading.Tasks.Task<BackupStatus> BackupSpecificRestorationStatusAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /backup/{backup}/restoration/status [GET]
        /// </summary>
        /// <remarks>
        /// TODO add a description:
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStatus)</returns>
        System.Threading.Tasks.Task<ApiResponse<BackupStatus>> BackupSpecificRestorationStatusWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IBackupApi : IBackupApiSync, IBackupApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class BackupApi : IBackupApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="BackupApi"/> class.
        /// </summary>
        /// <returns></returns>
        public BackupApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BackupApi"/> class.
        /// </summary>
        /// <returns></returns>
        public BackupApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BackupApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public BackupApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BackupApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public BackupApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /backup [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void Backup(Assets assets = default(Assets), int operationIndex = 0)
        {
            BackupWithHttpInfo(assets);
        }

        /// <summary>
        /// /backup [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> BackupWithHttpInfo(Assets assets = default(Assets), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = assets;

            localVarRequestOptions.Operation = "BackupApi.Backup";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/backup", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("Backup", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task BackupAsync(Assets assets = default(Assets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await BackupWithHttpInfoAsync(assets, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /backup [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="assets"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> BackupWithHttpInfoAsync(Assets assets = default(Assets), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = assets;

            localVarRequestOptions.Operation = "BackupApi.Backup";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/backup", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("Backup", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/asset [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void BackupAsset(Asset asset = default(Asset), int operationIndex = 0)
        {
            BackupAssetWithHttpInfo(asset);
        }

        /// <summary>
        /// /backup/asset [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> BackupAssetWithHttpInfo(Asset asset = default(Asset), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = asset;

            localVarRequestOptions.Operation = "BackupApi.BackupAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/backup/asset", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/asset [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task BackupAssetAsync(Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await BackupAssetWithHttpInfoAsync(asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /backup/asset [POST] 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> BackupAssetWithHttpInfoAsync(Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = asset;

            localVarRequestOptions.Operation = "BackupApi.BackupAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/backup/asset", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore [POST] Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Backup</returns>
        public Backup BackupRestoreSpecificBackup(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Backup> localVarResponse = BackupRestoreSpecificBackupWithHttpInfo(backup, backup2);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore [POST] Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Backup</returns>
        public Pieces.Os.Core.Client.ApiResponse<Backup> BackupRestoreSpecificBackupWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackup");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackup";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Backup>("/backup/{backup}/restore", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackup", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore [POST] Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Backup</returns>
        public async System.Threading.Tasks.Task<Backup> BackupRestoreSpecificBackupAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Backup> localVarResponse = await BackupRestoreSpecificBackupWithHttpInfoAsync(backup, backup2, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore [POST] Given a backup identifier version_timestamp.  we will restore a given backup from the cloud and override your local database!!!  NOTE!!!! This will NOT sync, ie all local snippets will get replaced with the restored database.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Backup)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Backup>> BackupRestoreSpecificBackupWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackup");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackup";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Backup>("/backup/{backup}/restore", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackup", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST] This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStreamedProgress</returns>
        public BackupStreamedProgress BackupRestoreSpecificBackupStreamed(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> localVarResponse = BackupRestoreSpecificBackupStreamedWithHttpInfo(backup, backup2);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST] This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStreamedProgress</returns>
        public Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackupStreamed");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackupStreamed";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<BackupStreamedProgress>("/backup/{backup}/restore/streamed", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackupStreamed", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST] This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStreamedProgress</returns>
        public async System.Threading.Tasks.Task<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> localVarResponse = await BackupRestoreSpecificBackupStreamedWithHttpInfoAsync(backup, backup2, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed [POST] This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStreamedProgress)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress>> BackupRestoreSpecificBackupStreamedWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackupStreamed");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackupStreamed";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<BackupStreamedProgress>("/backup/{backup}/restore/streamed", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackupStreamed", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS] WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStreamedProgress</returns>
        public BackupStreamedProgress BackupRestoreSpecificBackupStreamedWebsocket(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> localVarResponse = BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfo(backup, backup2);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS] WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStreamedProgress</returns>
        public Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackupStreamedWebsocket");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackupStreamedWebsocket";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<BackupStreamedProgress>("/backup/{backup}/restore/streamed/websocket", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackupStreamedWebsocket", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS] WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStreamedProgress</returns>
        public async System.Threading.Tasks.Task<BackupStreamedProgress> BackupRestoreSpecificBackupStreamedWebsocketAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress> localVarResponse = await BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfoAsync(backup, backup2, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restore/streamed/websocket [WS] WEBOCKET IMPLEMENTATION: This take a local database and ensure that it is backed up to the cloud.  NOTE: This is a streamed version of the /backups/&lt;backup&gt;/restore. and Since the Generator is unable to generate a streamed endpoint. this is a place holder, and will need to be implemented isolated from the code generator.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStreamedProgress)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<BackupStreamedProgress>> BackupRestoreSpecificBackupStreamedWebsocketWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupRestoreSpecificBackupStreamedWebsocket");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupRestoreSpecificBackupStreamedWebsocket";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<BackupStreamedProgress>("/backup/{backup}/restore/streamed/websocket", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupRestoreSpecificBackupStreamedWebsocket", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup} [GET] This will just get the metadata associated with a specific backup.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Backup</returns>
        public Backup BackupSpecificBackupSnapshot(string backup, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Backup> localVarResponse = BackupSpecificBackupSnapshotWithHttpInfo(backup);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup} [GET] This will just get the metadata associated with a specific backup.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Backup</returns>
        public Pieces.Os.Core.Client.ApiResponse<Backup> BackupSpecificBackupSnapshotWithHttpInfo(string backup, int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificBackupSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificBackupSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Backup>("/backup/{backup}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificBackupSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup} [GET] This will just get the metadata associated with a specific backup.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Backup</returns>
        public async System.Threading.Tasks.Task<Backup> BackupSpecificBackupSnapshotAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Backup> localVarResponse = await BackupSpecificBackupSnapshotWithHttpInfoAsync(backup, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup} [GET] This will just get the metadata associated with a specific backup.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Backup)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Backup>> BackupSpecificBackupSnapshotWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificBackupSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificBackupSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Backup>("/backup/{backup}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificBackupSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST] This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void BackupSpecificCreationCancel(string backup, int operationIndex = 0)
        {
            BackupSpecificCreationCancelWithHttpInfo(backup);
        }

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST] This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> BackupSpecificCreationCancelWithHttpInfo(string backup, int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificCreationCancel");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificCreationCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/backup/{backup}/creation/cancel", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificCreationCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST] This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task BackupSpecificCreationCancelAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await BackupSpecificCreationCancelWithHttpInfoAsync(backup, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /backup/{backup}/creation/cancel [POST] This is Going to cancel a create backup (streamed) or not streamed that is currently in progress.  This will throw a 500 if there is not a backup in progress.  TODO: ADD mofe DESCRIPITON To this.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> BackupSpecificCreationCancelWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificCreationCancel");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificCreationCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/backup/{backup}/creation/cancel", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificCreationCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/creation/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStatus</returns>
        public BackupStatus BackupSpecificCreationStatus(string backup, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStatus> localVarResponse = BackupSpecificCreationStatusWithHttpInfo(backup);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/creation/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<BackupStatus> BackupSpecificCreationStatusWithHttpInfo(string backup, int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificCreationStatus");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificCreationStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<BackupStatus>("/backup/{backup}/creation/status", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificCreationStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/creation/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStatus</returns>
        public async System.Threading.Tasks.Task<BackupStatus> BackupSpecificCreationStatusAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStatus> localVarResponse = await BackupSpecificCreationStatusWithHttpInfoAsync(backup, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/creation/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<BackupStatus>> BackupSpecificCreationStatusWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificCreationStatus");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificCreationStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<BackupStatus>("/backup/{backup}/creation/status", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificCreationStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST] This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void BackupSpecificRestorationCancel(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            BackupSpecificRestorationCancelWithHttpInfo(backup, backup2);
        }

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST] This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> BackupSpecificRestorationCancelWithHttpInfo(string backup, Backup backup2 = default(Backup), int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificRestorationCancel");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificRestorationCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/backup/{backup}/restoration/cancel", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificRestorationCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST] This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task BackupSpecificRestorationCancelAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await BackupSpecificRestorationCancelWithHttpInfoAsync(backup, backup2, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /backup/{backup}/restoration/cancel [POST] This will cancel a Restoration that is in progress and restore to the original database.  Note: if there is not a restore in progress we will return a 500.  TODO add
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="backup2"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> BackupSpecificRestorationCancelWithHttpInfoAsync(string backup, Backup backup2 = default(Backup), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificRestorationCancel");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter
            localVarRequestOptions.Data = backup2;

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificRestorationCancel";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/backup/{backup}/restoration/cancel", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificRestorationCancel", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restoration/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>BackupStatus</returns>
        public BackupStatus BackupSpecificRestorationStatus(string backup, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStatus> localVarResponse = BackupSpecificRestorationStatusWithHttpInfo(backup);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restoration/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of BackupStatus</returns>
        public Pieces.Os.Core.Client.ApiResponse<BackupStatus> BackupSpecificRestorationStatusWithHttpInfo(string backup, int operationIndex = 0)
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificRestorationStatus");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificRestorationStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<BackupStatus>("/backup/{backup}/restoration/status", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificRestorationStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /backup/{backup}/restoration/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of BackupStatus</returns>
        public async System.Threading.Tasks.Task<BackupStatus> BackupSpecificRestorationStatusAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<BackupStatus> localVarResponse = await BackupSpecificRestorationStatusWithHttpInfoAsync(backup, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /backup/{backup}/restoration/status [GET] TODO add a description:
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="backup">This is a identifier that is used to identify a specific backup.(version_timestamp)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (BackupStatus)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<BackupStatus>> BackupSpecificRestorationStatusWithHttpInfoAsync(string backup, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'backup' is set
            if (backup == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'backup' when calling BackupApi->BackupSpecificRestorationStatus");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("backup", Pieces.Os.Core.Client.ClientUtils.ParameterToString(backup)); // path parameter

            localVarRequestOptions.Operation = "BackupApi.BackupSpecificRestorationStatus";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<BackupStatus>("/backup/{backup}/restoration/status", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("BackupSpecificRestorationStatus", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
